/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;

public class InternalSchemaUtils {
    private InternalSchemaUtils() {
    }

    public static StructType convertToPhysicalSchema(StructType structType, StructType structType2, String string) {
        switch (string) {
            case "none": {
                return structType;
            }
            case "id": {
                throw new UnsupportedOperationException("Column mapping `id` mode is not yet supported");
            }
            case "name": {
                StructType structType3 = new StructType();
                for (StructField structField : structType.fields()) {
                    DataType dataType;
                    DataType dataType2 = structField.getDataType();
                    StructField structField2 = structType2.get(structField.getName());
                    if (dataType2 instanceof StructType) {
                        dataType = InternalSchemaUtils.convertToPhysicalSchema((StructType)structField.getDataType(), (StructType)structField2.getDataType(), string);
                    } else {
                        if (dataType2 instanceof ArrayType) {
                            throw new UnsupportedOperationException("NYI");
                        }
                        if (dataType2 instanceof MapType) {
                            throw new UnsupportedOperationException("NYI");
                        }
                        dataType = dataType2;
                    }
                    String string2 = structField2.getMetadata().get("delta.columnMapping.physicalName");
                    structType3 = structType3.add(string2, dataType);
                }
                return structType3;
            }
        }
        throw new UnsupportedOperationException("Unsupported column mapping mode: " + string);
    }
}

