/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.data.FileDataReadResult;
import io.delta.kernel.data.Row;
import io.delta.kernel.fs.FileStatus;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.data.AddFileColumnarBatch;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.util.Collections;
import java.util.Optional;

public class InternalUtils {
    private InternalUtils() {
    }

    public static Row getScanFileRow(FileStatus fileStatus) {
        AddFile addFile = new AddFile(fileStatus.getPath(), Collections.emptyMap(), fileStatus.getSize(), fileStatus.getModificationTime(), false, null);
        return (Row)new AddFileColumnarBatch(Collections.singletonList(addFile)).getRows().next();
    }

    public static Optional<Row> getSingularRow(CloseableIterator<FileDataReadResult> closeableIterator) throws IOException {
        Row row = null;
        while (closeableIterator.hasNext()) {
            CloseableIterator<Row> closeableIterator2 = ((FileDataReadResult)closeableIterator.next()).getData().getRows();
            Throwable throwable = null;
            try {
                while (closeableIterator2.hasNext()) {
                    if (row != null) {
                        throw new IllegalArgumentException("Given data batch contains more than one row");
                    }
                    row = (Row)closeableIterator2.next();
                }
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                if (closeableIterator2 == null) continue;
                if (throwable != null) {
                    try {
                        closeableIterator2.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    continue;
                }
                closeableIterator2.close();
            }
        }
        return Optional.ofNullable(row);
    }

    public static <T> Optional<T> getSingularElement(CloseableIterator<T> closeableIterator) throws IOException {
        try {
            Object t = null;
            while (closeableIterator.hasNext()) {
                if (t != null) {
                    throw new IllegalArgumentException("Iterator contains more than one element");
                }
                t = closeableIterator.next();
            }
            Optional<Object> optional = Optional.ofNullable(t);
            return optional;
        }
        finally {
            closeableIterator.close();
        }
    }

    public static void checkArgument(boolean bl) throws IllegalArgumentException {
        if (!bl) {
            throw new IllegalArgumentException();
        }
    }

    public static void checkArgument(boolean bl, String string) throws IllegalArgumentException {
        if (!bl) {
            throw new IllegalArgumentException(string);
        }
    }
}

