/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.client.ExpressionHandler;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.expressions.ExpressionEvaluator;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.Tuple2;
import java.sql.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class PartitionUtils {
    private PartitionUtils() {
    }

    public static StructType physicalSchemaWithoutPartitionColumns(final StructType structType, final StructType structType2, Set<String> set) {
        if (set == null || set.size() == 0) {
            return structType2;
        }
        HashMap<String, String> hashMap = new HashMap<String, String>(){
            {
                IntStream.range(0, structType.length()).mapToObj(n -> new Tuple2<StructField, StructField>(structType.at(n), structType2.at(n))).forEach((? super T tuple2) -> this.put(((StructField)tuple2._2).getName(), ((StructField)tuple2._1).getName()));
            }
        };
        return new StructType(structType2.fields().stream().filter(structField -> !set.contains(hashMap.get(structField.getName()))).collect(Collectors.toList()));
    }

    public static ColumnarBatch withPartitionColumns(ExpressionHandler expressionHandler, ColumnarBatch columnarBatch, StructType structType, Map<String, String> map, StructType structType2) {
        if (map == null || map.size() == 0) {
            return columnarBatch;
        }
        for (int i = 0; i < structType2.length(); ++i) {
            StructField structField = structType2.at(i);
            if (!map.containsKey(structField.getName())) continue;
            ExpressionEvaluator expressionEvaluator = expressionHandler.getEvaluator(structType, PartitionUtils.literalForPartitionValue(structField.getDataType(), map.get(structField.getName())));
            ColumnVector columnVector = expressionEvaluator.eval(columnarBatch);
            columnarBatch = columnarBatch.withNewColumn(i, structField, columnVector);
        }
        return columnarBatch;
    }

    private static Literal literalForPartitionValue(DataType dataType, String string) {
        if (string == null) {
            return Literal.ofNull(dataType);
        }
        if (dataType instanceof BooleanType) {
            return Literal.of(Boolean.parseBoolean(string));
        }
        if (dataType instanceof ByteType) {
            return Literal.of(Byte.parseByte(string));
        }
        if (dataType instanceof ShortType) {
            return Literal.of(Short.parseShort(string));
        }
        if (dataType instanceof IntegerType) {
            return Literal.of(Integer.parseInt(string));
        }
        if (dataType instanceof LongType) {
            return Literal.of(Long.parseLong(string));
        }
        if (dataType instanceof FloatType) {
            return Literal.of(Float.parseFloat(string));
        }
        if (dataType instanceof DoubleType) {
            return Literal.of(Double.parseDouble(string));
        }
        if (dataType instanceof StringType) {
            return Literal.of(string);
        }
        if (dataType instanceof BinaryType) {
            return Literal.of(string.getBytes());
        }
        if (dataType instanceof DateType) {
            return Literal.of(Date.valueOf(string));
        }
        throw new UnsupportedOperationException("Unsupported partition column: " + dataType);
    }
}

