/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.types;

import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.TimestampType;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Supplier;
import java.util.stream.Collectors;

public abstract class BasePrimitiveType
extends DataType {
    private static final Supplier<Map<String, DataType>> nameToPrimitiveTypeMap = () -> Collections.unmodifiableMap(new HashMap<String, DataType>(){
        {
            this.put("boolean", BooleanType.INSTANCE);
            this.put("byte", ByteType.INSTANCE);
            this.put("short", ShortType.INSTANCE);
            this.put("integer", IntegerType.INSTANCE);
            this.put("long", LongType.INSTANCE);
            this.put("float", FloatType.INSTANCE);
            this.put("double", DoubleType.INSTANCE);
            this.put("date", DateType.INSTANCE);
            this.put("timestamp", TimestampType.INSTANCE);
            this.put("binary", BinaryType.INSTANCE);
            this.put("string", StringType.INSTANCE);
        }
    });
    private final String primitiveTypeName;

    public static DataType createPrimitive(String string) {
        return Optional.ofNullable(nameToPrimitiveTypeMap.get().get(string)).orElseThrow(() -> new IllegalArgumentException("Unknown primitive type " + string));
    }

    public static boolean isPrimitiveType(String string) {
        return nameToPrimitiveTypeMap.get().containsKey(string);
    }

    public static List<DataType> getAllPrimitiveTypes() {
        return nameToPrimitiveTypeMap.get().values().stream().collect(Collectors.toList());
    }

    protected BasePrimitiveType(String string) {
        this.primitiveTypeName = string;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        BasePrimitiveType basePrimitiveType = (BasePrimitiveType)object;
        return this.primitiveTypeName.equals(basePrimitiveType.primitiveTypeName);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.primitiveTypeName);
    }

    @Override
    public String toString() {
        return this.primitiveTypeName;
    }

    @Override
    public String toJson() {
        return String.format("\"%s\"", this.primitiveTypeName);
    }
}

