/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.types;

import io.delta.kernel.types.DataType;
import java.util.Objects;

public class MapType
extends DataType {
    private final DataType keyType;
    private final DataType valueType;
    private final boolean valueContainsNull;

    public MapType(DataType dataType, DataType dataType2, boolean bl) {
        this.keyType = dataType;
        this.valueType = dataType2;
        this.valueContainsNull = bl;
    }

    public DataType getKeyType() {
        return this.keyType;
    }

    public DataType getValueType() {
        return this.valueType;
    }

    public boolean isValueContainsNull() {
        return this.valueContainsNull;
    }

    @Override
    public boolean equivalent(DataType dataType) {
        return dataType instanceof MapType && ((MapType)dataType).getKeyType().equivalent(this.keyType) && ((MapType)dataType).getValueType().equivalent(this.valueType) && ((MapType)dataType).valueContainsNull == this.valueContainsNull;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        MapType mapType = (MapType)object;
        return this.valueContainsNull == mapType.valueContainsNull && this.keyType.equals(mapType.keyType) && this.valueType.equals(mapType.valueType);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.keyType, this.valueType, this.valueContainsNull);
    }

    @Override
    public String toJson() {
        return String.format("{\"type\": \"map\",\"keyType\": %s,\"valueType\": %s,\"valueContainsNull\": %s}", this.keyType.toJson(), this.valueType.toJson(), this.valueContainsNull);
    }

    @Override
    public String toString() {
        return String.format("Map[%s, %s]", this.keyType, this.valueType);
    }
}

