/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.types;

import io.delta.kernel.expressions.Column;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.utils.Tuple2;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public final class StructType
extends DataType {
    private final Map<String, Tuple2<StructField, Integer>> nameToFieldAndOrdinal;
    private final List<StructField> fields;
    private final List<String> fieldNames;

    public StructType() {
        this(new ArrayList<StructField>());
    }

    public StructType(List<StructField> list) {
        this.fields = list;
        this.fieldNames = list.stream().map(structField -> structField.getName()).collect(Collectors.toList());
        this.nameToFieldAndOrdinal = new HashMap<String, Tuple2<StructField, Integer>>();
        for (int i = 0; i < list.size(); ++i) {
            this.nameToFieldAndOrdinal.put(list.get(i).getName(), new Tuple2<StructField, Integer>(list.get(i), i));
        }
    }

    public StructType add(StructField structField) {
        ArrayList<StructField> arrayList = new ArrayList<StructField>(this.fields);
        arrayList.add(structField);
        return new StructType(arrayList);
    }

    public StructType add(String string, DataType dataType) {
        return this.add(new StructField(string, dataType, true, new HashMap<String, String>()));
    }

    public StructType add(String string, DataType dataType, boolean bl) {
        return this.add(new StructField(string, dataType, bl, new HashMap<String, String>()));
    }

    public StructType add(String string, DataType dataType, Map<String, String> map) {
        return this.add(new StructField(string, dataType, true, map));
    }

    public List<StructField> fields() {
        return Collections.unmodifiableList(this.fields);
    }

    public List<String> fieldNames() {
        return this.fieldNames;
    }

    public int length() {
        return this.fields.size();
    }

    public int indexOf(String string) {
        return this.fieldNames.indexOf(string);
    }

    public StructField get(String string) {
        return (StructField)this.nameToFieldAndOrdinal.get((Object)string)._1;
    }

    public StructField at(int n) {
        return this.fields.get(n);
    }

    public Column column(int n) {
        StructField structField = this.at(n);
        return new Column(n, structField.getName(), structField.getDataType());
    }

    public Column column(String string) {
        Tuple2<StructField, Integer> tuple2 = this.nameToFieldAndOrdinal.get(string);
        System.out.println("Created column " + string + " with ordinal " + tuple2._2);
        return new Column((Integer)tuple2._2, string, ((StructField)tuple2._1).getDataType());
    }

    @Override
    public boolean equivalent(DataType dataType) {
        if (!(dataType instanceof StructType)) {
            return false;
        }
        StructType structType = (StructType)dataType;
        return structType.length() == this.length() && IntStream.range(0, this.length()).mapToObj(n -> structType.at(n).getDataType().equivalent(this.at(n).getDataType())).allMatch(bl -> bl);
    }

    @Override
    public String toString() {
        return String.format("%s(%s)", this.getClass().getSimpleName(), this.fields.stream().map(StructField::toString).collect(Collectors.joining(", ")));
    }

    @Override
    public String toJson() {
        String string = this.fields.stream().map(structField -> structField.toJson()).collect(Collectors.joining(",\n"));
        return String.format("{\n  \"type\" : \"struct\",\n  \"fields\" : [ %s ]\n}", string);
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StructType structType = (StructType)object;
        return this.nameToFieldAndOrdinal.equals(structType.nameToFieldAndOrdinal) && this.fields.equals(structType.fields) && this.fieldNames.equals(structType.fieldNames);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.nameToFieldAndOrdinal, this.fields, this.fieldNames);
    }
}

