/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.utils;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.function.Consumer;
import java.util.function.Function;

public interface CloseableIterator<T>
extends Iterator<T>,
Closeable {
    default public <U> CloseableIterator<U> map(final Function<T, U> function) {
        final CloseableIterator closeableIterator = this;
        return new CloseableIterator<U>(){

            @Override
            public void remove() {
                closeableIterator.remove();
            }

            @Override
            public void forEachRemaining(Consumer<? super U> consumer) {
                this.forEachRemaining(consumer);
            }

            @Override
            public boolean hasNext() {
                return closeableIterator.hasNext();
            }

            @Override
            public U next() {
                return function.apply(closeableIterator.next());
            }

            @Override
            public void close() throws IOException {
                closeableIterator.close();
            }
        };
    }
}

