/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.utils;

import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.Row;
import io.delta.kernel.fs.FileStatus;
import io.delta.kernel.internal.data.ScanStateRow;
import io.delta.kernel.internal.types.TableSchemaSerDe;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class Utils {
    public static <T> CloseableIterator<T> singletonCloseableIterator(final T t) {
        return new CloseableIterator<T>(){
            private boolean accessed;

            @Override
            public void close() throws IOException {
            }

            @Override
            public boolean hasNext() {
                return !this.accessed;
            }

            @Override
            public T next() {
                this.accessed = true;
                return t;
            }
        };
    }

    public static <T> CloseableIterator<T> toCloseableIterator(final Iterator<T> iterator) {
        return new CloseableIterator<T>(){

            @Override
            public void close() {
            }

            @Override
            public boolean hasNext() {
                return iterator.hasNext();
            }

            @Override
            public T next() {
                return iterator.next();
            }
        };
    }

    public static ColumnVector singletonColumnVector(final String string) {
        return new ColumnVector(){

            @Override
            public DataType getDataType() {
                return StringType.INSTANCE;
            }

            @Override
            public int getSize() {
                return 1;
            }

            @Override
            public void close() {
            }

            @Override
            public boolean isNullAt(int n) {
                return string == null;
            }

            @Override
            public String getString(int n) {
                if (n != 0) {
                    throw new IllegalArgumentException("Invalid row id: " + n);
                }
                return string;
            }
        };
    }

    public static StructType getLogicalSchema(TableClient tableClient, Row row) {
        int n = ScanStateRow.getLogicalSchemaStringColOrdinal();
        String string = row.getString(n);
        return TableSchemaSerDe.fromJson(tableClient.getJsonHandler(), string);
    }

    public static StructType getPhysicalSchema(TableClient tableClient, Row row) {
        int n = ScanStateRow.getPhysicalSchemaStringColOrdinal();
        String string = row.getString(n);
        return TableSchemaSerDe.fromJson(tableClient.getJsonHandler(), string);
    }

    public static List<String> getPartitionColumns(Row row) {
        int n = ScanStateRow.getPartitionColumnsColOrdinal();
        return row.getArray(n);
    }

    public static String getColumnMappingMode(Row row) {
        int n = ScanStateRow.getConfigurationColOrdinal();
        Map map = row.getMap(n);
        String string = (String)map.get("delta.columnMapping.mode");
        return string == null ? "none" : string;
    }

    public static FileStatus getFileStatus(Row row) {
        String string = row.getString(0);
        Long l = row.getLong(2);
        return FileStatus.of(string, l, 0L);
    }

    public static Map<String, String> getPartitionValues(Row row) {
        return row.getMap(1);
    }

    public static void closeCloseables(Closeable ... closeableArray) {
        Throwable throwable = null;
        for (Closeable closeable : closeableArray) {
            if (closeable == null) continue;
            try {
                closeable.close();
            }
            catch (Exception exception) {
                if (throwable == null) {
                    throwable = new RuntimeException(exception);
                    continue;
                }
                throwable.addSuppressed(exception);
            }
        }
        if (throwable != null) {
            throw throwable;
        }
    }

    public static void closeCloseablesSilently(Closeable ... closeableArray) {
        try {
            Utils.closeCloseables(closeableArray);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static Row requireNonNull(Row row, int n, String string) {
        if (row.isNullAt(n)) {
            throw new IllegalArgumentException("Expected a non-null value for column: " + string);
        }
        return row;
    }
}

