/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.InternalScanFileUtils;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.data.ScanStateRow;
import io.delta.kernel.internal.data.SelectionColumnVector;
import io.delta.kernel.internal.deletionvectors.DeletionVectorUtils;
import io.delta.kernel.internal.deletionvectors.RoaringBitmapArray;
import io.delta.kernel.internal.util.PartitionUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.util.Optional;

@Evolving
public interface Scan {
    public CloseableIterator<FilteredColumnarBatch> getScanFiles(TableClient var1);

    public Optional<Predicate> getRemainingFilter();

    public Row getScanState(TableClient var1);

    public static CloseableIterator<FilteredColumnarBatch> transformPhysicalData(final TableClient tableClient, final Row row, final Row row2, final CloseableIterator<ColumnarBatch> closeableIterator) throws IOException {
        return new CloseableIterator<FilteredColumnarBatch>(){
            boolean inited = false;
            StructType physicalReadSchema = null;
            StructType logicalReadSchema = null;
            String tablePath = null;
            RoaringBitmapArray currBitmap = null;
            DeletionVectorDescriptor currDV = null;

            private void initIfRequired() {
                if (this.inited) {
                    return;
                }
                this.physicalReadSchema = ScanStateRow.getPhysicalSchema(tableClient, row);
                this.logicalReadSchema = ScanStateRow.getLogicalSchema(tableClient, row);
                this.tablePath = ScanStateRow.getTableRoot(row);
                this.inited = true;
            }

            @Override
            public void close() throws IOException {
                closeableIterator.close();
            }

            @Override
            public boolean hasNext() {
                this.initIfRequired();
                return closeableIterator.hasNext();
            }

            @Override
            public FilteredColumnarBatch next() {
                Object object;
                Optional<ColumnVector> optional;
                this.initIfRequired();
                ColumnarBatch columnarBatch = (ColumnarBatch)closeableIterator.next();
                DeletionVectorDescriptor deletionVectorDescriptor = InternalScanFileUtils.getDeletionVectorDescriptorFromRow(row2);
                int n = columnarBatch.getSchema().indexOf(StructField.METADATA_ROW_INDEX_COLUMN_NAME);
                if (deletionVectorDescriptor == null) {
                    optional = Optional.empty();
                } else {
                    if (n == -1) {
                        throw new IllegalArgumentException("Row index column is not present in the data read from the Parquet file.");
                    }
                    if (!deletionVectorDescriptor.equals(this.currDV)) {
                        object = DeletionVectorUtils.loadNewDvAndBitmap(tableClient, this.tablePath, deletionVectorDescriptor);
                        this.currDV = (DeletionVectorDescriptor)((Tuple2)object)._1;
                        this.currBitmap = (RoaringBitmapArray)((Tuple2)object)._2;
                    }
                    object = columnarBatch.getColumnVector(n);
                    optional = Optional.of(new SelectionColumnVector(this.currBitmap, (ColumnVector)object));
                }
                if (n != -1) {
                    columnarBatch = columnarBatch.withDeletedColumnAt(n);
                }
                columnarBatch = PartitionUtils.withPartitionColumns(tableClient.getExpressionHandler(), columnarBatch, InternalScanFileUtils.getPartitionValues(row2), this.physicalReadSchema);
                switch (object = ScanStateRow.getColumnMappingMode(row)) {
                    case "name": 
                    case "id": {
                        columnarBatch = columnarBatch.withNewSchema(this.logicalReadSchema);
                        break;
                    }
                    case "none": {
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException("Column mapping mode is not yet supported: " + (String)object);
                    }
                }
                return new FilteredColumnarBatch(columnarBatch, optional);
            }
        };
    }
}

