/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Scan;
import io.delta.kernel.ScanBuilder;
import io.delta.kernel.client.TableClient;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.ScanImpl;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampType;
import java.util.List;
import java.util.Optional;

public class ScanBuilderImpl
implements ScanBuilder {
    private final Path dataPath;
    private final Protocol protocol;
    private final Metadata metadata;
    private final StructType snapshotSchema;
    private final LogReplay logReplay;
    private final TableClient tableClient;
    private StructType readSchema;
    private Optional<Predicate> predicate;

    public ScanBuilderImpl(Path path, Protocol protocol, Metadata metadata, StructType structType, LogReplay logReplay, TableClient tableClient) {
        this.dataPath = path;
        this.protocol = protocol;
        this.metadata = metadata;
        this.snapshotSchema = structType;
        this.logReplay = logReplay;
        this.tableClient = tableClient;
        this.readSchema = structType;
        this.predicate = Optional.empty();
    }

    @Override
    public ScanBuilder withFilter(TableClient tableClient, Predicate predicate) {
        if (this.predicate.isPresent()) {
            throw new IllegalArgumentException("There already exists a filter in current builder");
        }
        this.predicate = Optional.of(predicate);
        return this;
    }

    @Override
    public ScanBuilder withReadSchema(TableClient tableClient, StructType structType) {
        this.readSchema = structType;
        return this;
    }

    @Override
    public Scan build() {
        List<String> list = VectorUtils.toJavaList(this.metadata.getPartitionColumns());
        for (String string : list) {
            if (this.readSchema.indexOf(string) < 0 || !(this.readSchema.get(string).getDataType() instanceof TimestampType)) continue;
            throw new UnsupportedOperationException(String.format("Reading partition columns of TimestampType is unsupported.\nreadSchema: %s\npartitionColumns: %s", this.readSchema, list));
        }
        return new ScanImpl(this.snapshotSchema, this.readSchema, this.protocol, this.metadata, this.logReplay, this.predicate, this.dataPath);
    }
}

