/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Scan;
import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.expressions.AlwaysTrue;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.expressions.PredicateEvaluator;
import io.delta.kernel.expressions.ScalarExpression;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.data.ScanStateRow;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.skipping.DataSkippingPredicate;
import io.delta.kernel.internal.skipping.DataSkippingUtils;
import io.delta.kernel.internal.skipping.StatsSchemaHelper;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.PartitionUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;

public class ScanImpl
implements Scan {
    private final StructType snapshotSchema;
    private final StructType readSchema;
    private final Protocol protocol;
    private final Metadata metadata;
    private final LogReplay logReplay;
    private final Path dataPath;
    private final Optional<Tuple2<Predicate, Predicate>> partitionAndDataFilters;
    private boolean accessedScanFiles;

    public ScanImpl(StructType structType, StructType structType2, Protocol protocol, Metadata metadata, LogReplay logReplay, Optional<Predicate> optional, Path path) {
        this.snapshotSchema = structType;
        this.readSchema = structType2;
        this.protocol = protocol;
        this.metadata = metadata;
        this.logReplay = logReplay;
        this.partitionAndDataFilters = this.splitFilters(optional);
        this.dataPath = path;
    }

    @Override
    public CloseableIterator<FilteredColumnarBatch> getScanFiles(TableClient tableClient) {
        if (this.accessedScanFiles) {
            throw new IllegalStateException("Scan files are already fetched from this instance");
        }
        this.accessedScanFiles = true;
        Optional<DataSkippingPredicate> optional = this.getDataSkippingFilter();
        boolean bl = optional.isPresent();
        CloseableIterator<FilteredColumnarBatch> closeableIterator = this.logReplay.getAddFilesAsColumnarBatches(bl);
        closeableIterator = this.applyPartitionPruning(tableClient, closeableIterator);
        if (bl) {
            return this.applyDataSkipping(tableClient, closeableIterator, optional.get());
        }
        return closeableIterator;
    }

    @Override
    public Row getScanState(TableClient tableClient) {
        StructType structType = ColumnMapping.convertToPhysicalSchema(this.readSchema, this.snapshotSchema, ColumnMapping.getColumnMappingMode(this.metadata.getConfiguration()));
        List list = VectorUtils.toJavaList(this.metadata.getPartitionColumns());
        StructType structType2 = PartitionUtils.physicalSchemaWithoutPartitionColumns(this.readSchema, structType, new HashSet<String>(list));
        if (this.protocol.getReaderFeatures().contains("deletionVectors")) {
            structType2 = structType2.add(StructField.METADATA_ROW_INDEX_COLUMN);
        }
        return ScanStateRow.of(this.metadata, this.protocol, this.readSchema.toJson(), structType.toJson(), structType2.toJson(), this.dataPath.toUri().toString());
    }

    @Override
    public Optional<Predicate> getRemainingFilter() {
        return this.getDataFilters();
    }

    private Optional<Tuple2<Predicate, Predicate>> splitFilters(Optional<Predicate> optional) {
        return optional.map(predicate -> PartitionUtils.splitMetadataAndDataPredicates(predicate, this.metadata.getPartitionColNames()));
    }

    private Optional<Predicate> getDataFilters() {
        return this.removeAlwaysTrue(this.partitionAndDataFilters.map(tuple2 -> (Predicate)tuple2._2));
    }

    private Optional<Predicate> getPartitionsFilters() {
        return this.removeAlwaysTrue(this.partitionAndDataFilters.map(tuple2 -> (Predicate)tuple2._1));
    }

    private Optional<Predicate> removeAlwaysTrue(Optional<Predicate> optional) {
        return optional.filter(predicate -> !predicate.getName().equalsIgnoreCase("ALWAYS_TRUE"));
    }

    private CloseableIterator<FilteredColumnarBatch> applyPartitionPruning(final TableClient tableClient, final CloseableIterator<FilteredColumnarBatch> closeableIterator) {
        Optional<Predicate> optional = this.getPartitionsFilters();
        if (!optional.isPresent()) {
            return closeableIterator;
        }
        Set<String> set = this.metadata.getPartitionColNames();
        Map<String, StructField> map = this.metadata.getSchema().fields().stream().filter(structField -> set.contains(structField.getName())).collect(Collectors.toMap(structField -> structField.getName().toLowerCase(Locale.ENGLISH), Function.identity()));
        final Predicate predicate = PartitionUtils.rewritePartitionPredicateOnScanFileSchema(optional.get(), map);
        return new CloseableIterator<FilteredColumnarBatch>(){
            PredicateEvaluator predicateEvaluator = null;

            @Override
            public boolean hasNext() {
                return closeableIterator.hasNext();
            }

            @Override
            public FilteredColumnarBatch next() {
                FilteredColumnarBatch filteredColumnarBatch = (FilteredColumnarBatch)closeableIterator.next();
                if (this.predicateEvaluator == null) {
                    this.predicateEvaluator = tableClient.getExpressionHandler().getPredicateEvaluator(filteredColumnarBatch.getData().getSchema(), predicate);
                }
                ColumnVector columnVector = this.predicateEvaluator.eval(filteredColumnarBatch.getData(), filteredColumnarBatch.getSelectionVector());
                return new FilteredColumnarBatch(filteredColumnarBatch.getData(), Optional.of(columnVector));
            }

            @Override
            public void close() throws IOException {
                closeableIterator.close();
            }
        };
    }

    private Optional<DataSkippingPredicate> getDataSkippingFilter() {
        return this.getDataFilters().flatMap(predicate -> DataSkippingUtils.constructDataSkippingFilter(predicate, this.metadata.getDataSchema()));
    }

    private CloseableIterator<FilteredColumnarBatch> applyDataSkipping(TableClient tableClient, CloseableIterator<FilteredColumnarBatch> closeableIterator, DataSkippingPredicate dataSkippingPredicate) {
        StructType structType = DataSkippingUtils.pruneStatsSchema(StatsSchemaHelper.getStatsSchema(this.metadata.getDataSchema()), dataSkippingPredicate.getReferencedCols());
        Predicate predicate = new Predicate("=", new ScalarExpression("COALESCE", Arrays.asList(dataSkippingPredicate, Literal.ofBoolean(true))), AlwaysTrue.ALWAYS_TRUE);
        PredicateEvaluator predicateEvaluator = tableClient.getExpressionHandler().getPredicateEvaluator(structType, predicate);
        return closeableIterator.map(filteredColumnarBatch -> {
            ColumnVector columnVector = predicateEvaluator.eval(DataSkippingUtils.parseJsonStats(tableClient, filteredColumnarBatch, structType), filteredColumnarBatch.getSelectionVector());
            return new FilteredColumnarBatch(filteredColumnarBatch.getData(), Optional.of(columnVector));
        });
    }
}

