/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.ScanBuilder;
import io.delta.kernel.Snapshot;
import io.delta.kernel.client.TableClient;
import io.delta.kernel.internal.ScanBuilderImpl;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.internal.snapshot.SnapshotHint;
import io.delta.kernel.types.StructType;
import java.util.Optional;

public class SnapshotImpl
implements Snapshot {
    private final Path dataPath;
    private final long version;
    private final LogReplay logReplay;
    private final Protocol protocol;
    private final Metadata metadata;

    public SnapshotImpl(Path path, Path path2, long l, LogSegment logSegment, TableClient tableClient, long l2, Optional<SnapshotHint> optional) {
        this.dataPath = path2;
        this.version = l;
        this.logReplay = new LogReplay(path, path2, l, tableClient, logSegment, optional);
        this.protocol = this.logReplay.getProtocol();
        this.metadata = this.logReplay.getMetadata();
    }

    @Override
    public long getVersion(TableClient tableClient) {
        return this.version;
    }

    @Override
    public StructType getSchema(TableClient tableClient) {
        return this.getMetadata().getSchema();
    }

    @Override
    public ScanBuilder getScanBuilder(TableClient tableClient) {
        return new ScanBuilderImpl(this.dataPath, this.protocol, this.metadata, this.getSchema(tableClient), this.logReplay, tableClient);
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    public Optional<Long> getLatestTransactionVersion(String string) {
        return this.logReplay.getLatestTransactionIdentifier(string);
    }
}

