/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Snapshot;
import io.delta.kernel.Table;
import io.delta.kernel.TableNotFoundException;
import io.delta.kernel.client.TableClient;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.snapshot.SnapshotManager;
import java.io.FileNotFoundException;
import java.io.IOException;

public class TableImpl
implements Table {
    private final Path logPath;
    private final Path dataPath;
    private final SnapshotManager snapshotManager;

    public static Table forPath(TableClient tableClient, String string) throws TableNotFoundException {
        String string2;
        try {
            string2 = tableClient.getFileSystemClient().resolvePath(string);
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TableNotFoundException(string, fileNotFoundException);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
        Path path = new Path(string2);
        Path path2 = new Path(path, "_delta_log");
        return new TableImpl(path2, path);
    }

    public TableImpl(Path path, Path path2) {
        this.logPath = path;
        this.dataPath = path2;
        this.snapshotManager = new SnapshotManager();
    }

    @Override
    public Snapshot getLatestSnapshot(TableClient tableClient) throws TableNotFoundException {
        return this.snapshotManager.buildLatestSnapshot(tableClient, this.logPath, this.dataPath);
    }
}

