/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.checkpoints;

import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.FileNames;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class CheckpointInstance
implements Comparable<CheckpointInstance> {
    public static final CheckpointInstance MAX_VALUE = new CheckpointInstance(Long.MAX_VALUE);
    public final long version;
    public final Optional<Integer> numParts;

    public CheckpointInstance(String string) {
        String[] stringArray = this.getPathName(string).split("\\.");
        if (stringArray.length == 3 && stringArray[1].equals("checkpoint") && stringArray[2].equals("parquet")) {
            this.version = Long.parseLong(stringArray[0]);
            this.numParts = Optional.empty();
        } else if (stringArray.length == 5 && stringArray[1].equals("checkpoint") && stringArray[4].equals("parquet")) {
            this.version = Long.parseLong(stringArray[0]);
            this.numParts = Optional.of(Integer.parseInt(stringArray[3]));
        } else {
            throw new RuntimeException("Unrecognized checkpoint path format: " + this.getPathName(string));
        }
    }

    public CheckpointInstance(long l) {
        this(l, Optional.empty());
    }

    public CheckpointInstance(long l, Optional<Integer> optional) {
        this.version = l;
        this.numParts = optional;
    }

    boolean isNotLaterThan(CheckpointInstance checkpointInstance) {
        if (checkpointInstance == MAX_VALUE) {
            return true;
        }
        return this.version <= checkpointInstance.version;
    }

    public List<Path> getCorrespondingFiles(Path path) {
        if (this == MAX_VALUE) {
            throw new IllegalStateException("Can't get files for CheckpointVersion.MaxValue.");
        }
        return this.numParts.map(n -> FileNames.checkpointFileWithParts(path, this.version, n)).orElseGet(() -> Collections.singletonList(FileNames.checkpointFileSingular(path, this.version)));
    }

    @Override
    public int compareTo(CheckpointInstance checkpointInstance) {
        if (this.version == checkpointInstance.version) {
            return Long.compare(this.numParts.orElse(1).intValue(), checkpointInstance.numParts.orElse(1).intValue());
        }
        return Long.compare(this.version, checkpointInstance.version);
    }

    public String toString() {
        return "CheckpointInstance{version=" + this.version + ", numParts=" + this.numParts + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        CheckpointInstance checkpointInstance = (CheckpointInstance)object;
        return this.version == checkpointInstance.version && Objects.equals(this.numParts, checkpointInstance.numParts);
    }

    public int hashCode() {
        return Objects.hash(this.version, this.numParts);
    }

    private String getPathName(String string) {
        int n = string.lastIndexOf("/");
        return string.substring(n + 1);
    }
}

