/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.checkpoints;

import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.checkpoints.CheckpointInstance;
import io.delta.kernel.internal.checkpoints.CheckpointMetaData;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;

public class Checkpointer {
    public static final String LAST_CHECKPOINT_FILE_NAME = "_last_checkpoint";
    private final Path lastCheckpointFilePath;

    public static Optional<CheckpointInstance> getLatestCompleteCheckpointFromList(List<CheckpointInstance> list, CheckpointInstance checkpointInstance3) {
        List list2 = list.stream().filter(checkpointInstance2 -> checkpointInstance2.isNotLaterThan(checkpointInstance3)).collect(Collectors.groupingBy(checkpointInstance -> checkpointInstance)).entrySet().stream().filter(entry -> {
            CheckpointInstance checkpointInstance = (CheckpointInstance)entry.getKey();
            List list = (List)entry.getValue();
            if (checkpointInstance.numParts.isPresent()) {
                return list.size() == ((CheckpointInstance)entry.getKey()).numParts.get().intValue();
            }
            return list.size() == 1;
        }).map(Map.Entry::getKey).collect(Collectors.toList());
        if (list2.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Collections.max(list2));
    }

    public Checkpointer(Path path) {
        this.lastCheckpointFilePath = new Path(path, LAST_CHECKPOINT_FILE_NAME);
    }

    public Optional<CheckpointMetaData> readLastCheckpointFile(TableClient tableClient) {
        return this.loadMetadataFromFile(tableClient);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<CheckpointMetaData> loadMetadataFromFile(TableClient tableClient) {
        try {
            FileStatus fileStatus = FileStatus.of(this.lastCheckpointFilePath.toString(), 0L, 0L);
            try (CloseableIterator<ColumnarBatch> closeableIterator = tableClient.getJsonHandler().readJsonFiles(Utils.singletonCloseableIterator(fileStatus), CheckpointMetaData.READ_SCHEMA, Optional.empty());){
                Optional<Row> optional2 = InternalUtils.getSingularRow(closeableIterator);
                Optional<CheckpointMetaData> optional = optional2.map(CheckpointMetaData::fromRow);
                return optional;
            }
        }
        catch (Exception exception) {
            return Optional.empty();
        }
    }
}

