/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.client.TableClient;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.internal.replay.ActionWrapper;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;

class ActionsIterator
implements CloseableIterator<ActionWrapper> {
    private final TableClient tableClient;
    private final Iterator<FileStatus> filesIter;
    private final StructType readSchema;
    private Optional<CloseableIterator<ActionWrapper>> actionsIter;
    private boolean closed;

    ActionsIterator(TableClient tableClient, List<FileStatus> list, StructType structType) {
        this.tableClient = tableClient;
        this.filesIter = list.iterator();
        this.readSchema = structType;
        this.actionsIter = Optional.empty();
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Can't call `hasNext` on a closed iterator.");
        }
        this.tryEnsureNextActionsIterIsReady();
        return this.actionsIter.isPresent();
    }

    @Override
    public ActionWrapper next() {
        if (this.closed) {
            throw new IllegalStateException("Can't call `next` on a closed iterator.");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        return (ActionWrapper)this.actionsIter.get().next();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed && this.actionsIter.isPresent()) {
            this.actionsIter.get().close();
            this.actionsIter = Optional.empty();
            this.closed = true;
        }
    }

    private void tryEnsureNextActionsIterIsReady() {
        if (this.actionsIter.isPresent()) {
            if (this.actionsIter.get().hasNext()) {
                return;
            }
            Utils.closeCloseables(this.actionsIter.get());
            this.actionsIter = Optional.empty();
        }
        while (this.filesIter.hasNext()) {
            this.actionsIter = Optional.of(this.getNextActionsIter());
            if (this.actionsIter.get().hasNext()) {
                return;
            }
            Utils.closeCloseables(this.actionsIter.get());
            this.actionsIter = Optional.empty();
        }
    }

    private CloseableIterator<ActionWrapper> getNextActionsIter() {
        FileStatus fileStatus = this.filesIter.next();
        try {
            if (fileStatus.getPath().endsWith(".json")) {
                long l = FileNames.deltaVersion(fileStatus.getPath());
                CloseableIterator<ColumnarBatch> closeableIterator = this.tableClient.getJsonHandler().readJsonFiles(Utils.singletonCloseableIterator(fileStatus), this.readSchema, Optional.empty());
                return this.combine(closeableIterator, false, l);
            }
            if (fileStatus.getPath().endsWith(".parquet")) {
                long l = FileNames.checkpointVersion(fileStatus.getPath());
                CloseableIterator<ColumnarBatch> closeableIterator = this.tableClient.getParquetHandler().readParquetFiles(Utils.singletonCloseableIterator(fileStatus), this.readSchema, Optional.empty());
                return this.combine(closeableIterator, true, l);
            }
            throw new IllegalStateException(String.format("Unexpected log file path: %s", fileStatus.getPath()));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private CloseableIterator<ActionWrapper> combine(final CloseableIterator<ColumnarBatch> closeableIterator, final boolean bl, final long l) {
        return new CloseableIterator<ActionWrapper>(){

            @Override
            public boolean hasNext() {
                return closeableIterator.hasNext();
            }

            @Override
            public ActionWrapper next() {
                return new ActionWrapper((ColumnarBatch)closeableIterator.next(), bl, l);
            }

            @Override
            public void close() throws IOException {
                closeableIterator.close();
            }
        };
    }
}

