/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.internal.data.StructRow;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public final class VectorUtils {
    private VectorUtils() {
    }

    public static <T> List<T> toJavaList(ArrayValue arrayValue) {
        ColumnVector columnVector = arrayValue.getElements();
        DataType dataType = columnVector.getDataType();
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (int i = 0; i < arrayValue.getSize(); ++i) {
            arrayList.add(VectorUtils.getValueAsObject(columnVector, dataType, i));
        }
        return arrayList;
    }

    public static <K, V> Map<K, V> toJavaMap(MapValue mapValue) {
        ColumnVector columnVector = mapValue.getKeys();
        DataType dataType = columnVector.getDataType();
        ColumnVector columnVector2 = mapValue.getValues();
        DataType dataType2 = columnVector2.getDataType();
        HashMap<Object, Object> hashMap = new HashMap<Object, Object>();
        for (int i = 0; i < mapValue.getSize(); ++i) {
            Object object = VectorUtils.getValueAsObject(columnVector, dataType, i);
            Object object2 = VectorUtils.getValueAsObject(columnVector2, dataType2, i);
            hashMap.put(object, object2);
        }
        return hashMap;
    }

    private static Object getValueAsObject(ColumnVector columnVector, DataType dataType, int n) {
        if (columnVector.isNullAt(n)) {
            return null;
        }
        if (dataType instanceof BooleanType) {
            return columnVector.getBoolean(n);
        }
        if (dataType instanceof ByteType) {
            return columnVector.getByte(n);
        }
        if (dataType instanceof ShortType) {
            return columnVector.getShort(n);
        }
        if (dataType instanceof IntegerType || dataType instanceof DateType) {
            return columnVector.getInt(n);
        }
        if (dataType instanceof LongType || dataType instanceof TimestampType) {
            return columnVector.getLong(n);
        }
        if (dataType instanceof FloatType) {
            return Float.valueOf(columnVector.getFloat(n));
        }
        if (dataType instanceof DoubleType) {
            return columnVector.getDouble(n);
        }
        if (dataType instanceof StringType) {
            return columnVector.getString(n);
        }
        if (dataType instanceof BinaryType) {
            return columnVector.getBinary(n);
        }
        if (dataType instanceof StructType) {
            return StructRow.fromStructVector(columnVector, n);
        }
        if (dataType instanceof DecimalType) {
            return columnVector.getDecimal(n);
        }
        if (dataType instanceof ArrayType) {
            return VectorUtils.toJavaList(columnVector.getArray(n));
        }
        if (dataType instanceof MapType) {
            return VectorUtils.toJavaMap(columnVector.getMap(n));
        }
        throw new UnsupportedOperationException("unsupported data type");
    }
}

