/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.types;

import io.delta.kernel.annotation.Evolving;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.FieldMetadata;
import io.delta.kernel.types.LongType;
import java.util.Objects;

@Evolving
public class StructField {
    private static String IS_METADATA_COLUMN_KEY = "isMetadataColumn";
    public static String METADATA_ROW_INDEX_COLUMN_NAME = "_metadata.row_index";
    public static StructField METADATA_ROW_INDEX_COLUMN = new StructField(METADATA_ROW_INDEX_COLUMN_NAME, LongType.LONG, false, FieldMetadata.builder().putBoolean(IS_METADATA_COLUMN_KEY, true).build());
    private final String name;
    private final DataType dataType;
    private final boolean nullable;
    private final FieldMetadata metadata;

    public StructField(String string, DataType dataType, boolean bl) {
        this(string, dataType, bl, FieldMetadata.empty());
    }

    public StructField(String string, DataType dataType, boolean bl, FieldMetadata fieldMetadata) {
        this.name = string;
        this.dataType = dataType;
        this.nullable = bl;
        this.metadata = fieldMetadata;
    }

    public String getName() {
        return this.name;
    }

    public DataType getDataType() {
        return this.dataType;
    }

    public FieldMetadata getMetadata() {
        return this.metadata;
    }

    public boolean isNullable() {
        return this.nullable;
    }

    public boolean isMetadataColumn() {
        return this.metadata.contains(IS_METADATA_COLUMN_KEY) && (Boolean)this.metadata.get(IS_METADATA_COLUMN_KEY) != false;
    }

    public boolean isDataColumn() {
        return !this.isMetadataColumn();
    }

    public String toString() {
        return String.format("StructField(name=%s,type=%s,nullable=%s,metadata=%s)", this.name, this.dataType, this.nullable, this.metadata.toJson());
    }

    public String toJson() {
        return String.format("{\n  \"name\" : \"%s\",\n  \"type\" : %s,\n  \"nullable\" : %s, \n  \"metadata\" : %s\n}", this.name, this.dataType.toJson(), this.nullable, this.metadata.toJson());
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        StructField structField = (StructField)object;
        return this.nullable == structField.nullable && this.name.equals(structField.name) && this.dataType.equals(structField.dataType) && this.metadata.equals(structField.metadata);
    }

    public int hashCode() {
        return Objects.hash(this.name, this.dataType, this.nullable, this.metadata);
    }
}

