/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.checkpoints.CheckpointInstance;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class DeltaHistoryManager {
    private static final Logger logger = LoggerFactory.getLogger(DeltaHistoryManager.class);

    private DeltaHistoryManager() {
    }

    public static long getActiveCommitAtTimestamp(Engine engine, Path path, long l) throws TableNotFoundException {
        long l2 = DeltaHistoryManager.getEarliestRecreatableCommit(engine, path);
        List<Commit> list = DeltaHistoryManager.getCommits(engine, path, l2);
        Commit commit = DeltaHistoryManager.lastCommitBeforeOrAtTimestamp(list, l).orElseThrow(() -> DeltaErrors.timestampBeforeFirstAvailableCommit(path.getParent().toString(), l, ((Commit)list.get((int)0)).timestamp, ((Commit)list.get((int)0)).version));
        if (commit == list.get(list.size() - 1) && commit.timestamp < l) {
            throw DeltaErrors.timestampAfterLatestCommit(path.getParent().toString(), l, commit.timestamp, commit.version);
        }
        return commit.version;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static long getEarliestRecreatableCommit(Engine engine, Path path) throws TableNotFoundException {
        try (CloseableIterator<FileStatus> closeableIterator = DeltaHistoryManager.listFrom(engine, path, 0L).filter(fileStatus -> FileNames.isCommitFile(Path.getName(fileStatus.getPath())) || FileNames.isCheckpointFile(Path.getName(fileStatus.getPath())));){
            if (!closeableIterator.hasNext()) {
                throw new RuntimeException(String.format("No delta files found in the directory: %s", path));
            }
            HashMap<Tuple2<Long, Integer>, Integer> hashMap = new HashMap<Tuple2<Long, Integer>, Integer>();
            long l = Long.MAX_VALUE;
            Optional<Object> optional = Optional.empty();
            while (closeableIterator.hasNext()) {
                int n;
                long l2;
                String string = ((FileStatus)closeableIterator.next()).getPath();
                if (FileNames.isCommitFile(Path.getName(string))) {
                    l2 = FileNames.deltaVersion(string);
                    if (l2 == 0L) {
                        long l3 = l2;
                        return l3;
                    }
                    l = Math.min(l2, l);
                    if (!optional.isPresent() || (Long)optional.get() < l) continue;
                    long l4 = (Long)optional.get();
                    return l4;
                }
                if (!FileNames.isCheckpointFile(string)) continue;
                l2 = FileNames.checkpointVersion(string);
                CheckpointInstance checkpointInstance = new CheckpointInstance(string);
                if (!checkpointInstance.numParts.isPresent()) {
                    optional = Optional.of(l2);
                    continue;
                }
                int n2 = checkpointInstance.numParts.orElse(1);
                if (n2 == (n = hashMap.getOrDefault(new Tuple2<Long, Integer>(l2, n2), 0).intValue()) + 1) {
                    optional = Optional.of(l2);
                }
                hashMap.put(new Tuple2<Long, Integer>(l2, n2), n + 1);
            }
            if (optional.isPresent() && (Long)optional.get() >= l) {
                long l5 = (Long)optional.get();
                return l5;
            }
            if (l < Long.MAX_VALUE) {
                throw new RuntimeException(String.format("No recreatable commits found at %s", path));
            }
            throw new RuntimeException(String.format("No commits found at %s", path));
        }
        catch (IOException iOException) {
            throw new RuntimeException("Could not close iterator", iOException);
        }
    }

    private static CloseableIterator<FileStatus> listFrom(Engine engine, Path path, long l) throws TableNotFoundException {
        Path path2 = path.getParent();
        try {
            CloseableIterator<FileStatus> closeableIterator = engine.getFileSystemClient().listFrom(FileNames.listingPrefix(path, l));
            if (!closeableIterator.hasNext()) {
                throw new TableNotFoundException(path2.toString());
            }
            return closeableIterator;
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TableNotFoundException(path2.toString());
        }
        catch (IOException iOException) {
            throw new RuntimeException("Failed to list the files in delta log", iOException);
        }
    }

    private static List<Commit> getCommits(Engine engine, Path path, long l) throws TableNotFoundException {
        CloseableIterator<Commit> closeableIterator = DeltaHistoryManager.listFrom(engine, path, l).filter(fileStatus -> FileNames.isCommitFile(Path.getName(fileStatus.getPath()))).map(fileStatus -> new Commit(FileNames.deltaVersion(fileStatus.getPath()), fileStatus.getModificationTime()));
        return DeltaHistoryManager.monotonizeCommitTimestamps(closeableIterator);
    }

    private static List<Commit> monotonizeCommitTimestamps(CloseableIterator<Commit> closeableIterator) {
        ArrayList<Commit> arrayList = new ArrayList<Commit>();
        long l = Long.MIN_VALUE;
        long l2 = Long.MIN_VALUE;
        while (closeableIterator.hasNext()) {
            Commit commit = (Commit)closeableIterator.next();
            assert (l2 < commit.version);
            if (l >= commit.timestamp) {
                logger.warn("Found Delta commit {} with a timestamp {} which is greater than the next commit timestamp {}.", new Object[]{l2, l, commit.timestamp});
                commit = new Commit(commit.version, l + 1L);
            }
            arrayList.add(commit);
            l = commit.timestamp;
            l2 = commit.version;
        }
        return arrayList;
    }

    private static Optional<Commit> lastCommitBeforeOrAtTimestamp(List<Commit> list, long l) {
        int n = -1;
        while (n + 1 < list.size() && list.get((int)(n + 1)).timestamp <= l) {
            ++n;
        }
        return Optional.ofNullable(n < 0 ? null : list.get(n));
    }

    private static class Commit {
        final long version;
        final long timestamp;

        Commit(long l, long l2) {
            this.version = l;
            this.timestamp = l2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Commit commit = (Commit)object;
            return Objects.equals(this.version, commit.version) && Objects.equals(this.timestamp, commit.timestamp);
        }

        public int hashCode() {
            return Objects.hash(this.version, this.timestamp);
        }
    }
}

