/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.expressions.Predicate;
import io.delta.kernel.internal.checkpoints.SidecarFile;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.ActionWrapper;
import io.delta.kernel.internal.replay.DeltaLogFile;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.stream.Collectors;

class ActionsIterator
implements CloseableIterator<ActionWrapper> {
    private final Engine engine;
    private final Optional<Predicate> checkpointPredicate;
    private final LinkedList<DeltaLogFile> filesList;
    private final StructType readSchema;
    private final boolean schemaContainsAddOrRemoveFiles;
    private Optional<CloseableIterator<ActionWrapper>> actionsIter;
    private boolean closed;

    ActionsIterator(Engine engine, List<FileStatus> list, StructType structType, Optional<Predicate> optional) {
        this.engine = engine;
        this.checkpointPredicate = optional;
        this.filesList = new LinkedList();
        this.filesList.addAll(list.stream().map((? super T fileStatus) -> DeltaLogFile.forCommitOrCheckpoint(fileStatus)).collect(Collectors.toList()));
        this.readSchema = structType;
        this.actionsIter = Optional.empty();
        this.schemaContainsAddOrRemoveFiles = LogReplay.containsAddOrRemoveFileActions(structType);
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Can't call `hasNext` on a closed iterator.");
        }
        this.tryEnsureNextActionsIterIsReady();
        return this.actionsIter.isPresent();
    }

    @Override
    public ActionWrapper next() {
        if (this.closed) {
            throw new IllegalStateException("Can't call `next` on a closed iterator.");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException("No next element");
        }
        return (ActionWrapper)this.actionsIter.get().next();
    }

    @Override
    public void close() throws IOException {
        if (!this.closed && this.actionsIter.isPresent()) {
            this.actionsIter.get().close();
            this.actionsIter = Optional.empty();
            this.closed = true;
        }
    }

    private void tryEnsureNextActionsIterIsReady() {
        if (this.actionsIter.isPresent()) {
            if (this.actionsIter.get().hasNext()) {
                return;
            }
            Utils.closeCloseables(this.actionsIter.get());
            this.actionsIter = Optional.empty();
        }
        while (!this.filesList.isEmpty()) {
            this.actionsIter = Optional.of(this.getNextActionsIter());
            if (this.actionsIter.get().hasNext()) {
                return;
            }
            Utils.closeCloseables(this.actionsIter.get());
            this.actionsIter = Optional.empty();
        }
    }

    private CloseableIterator<ColumnarBatch> getActionsIterFromSinglePartOrV2Checkpoint(final FileStatus fileStatus, String string) throws IOException {
        CloseableIterator<ColumnarBatch> closeableIterator;
        StructType structType = this.readSchema;
        if (this.schemaContainsAddOrRemoveFiles) {
            structType = LogReplay.withSidecarFileSchema(this.readSchema);
        }
        final long l = FileNames.checkpointVersion(fileStatus.getPath());
        if (string.endsWith(".parquet")) {
            closeableIterator = this.engine.getParquetHandler().readParquetFiles(Utils.singletonCloseableIterator(fileStatus), structType, this.checkpointPredicate);
        } else if (string.endsWith(".json")) {
            closeableIterator = this.engine.getJsonHandler().readJsonFiles(Utils.singletonCloseableIterator(fileStatus), structType, this.checkpointPredicate);
        } else {
            throw new IOException("Unrecognized top level v2 checkpoint file format: " + string);
        }
        return new CloseableIterator<ColumnarBatch>(){

            @Override
            public void close() throws IOException {
                closeableIterator.close();
            }

            @Override
            public boolean hasNext() {
                return closeableIterator.hasNext();
            }

            @Override
            public ColumnarBatch next() {
                ColumnarBatch columnarBatch = (ColumnarBatch)closeableIterator.next();
                if (ActionsIterator.this.schemaContainsAddOrRemoveFiles) {
                    return ActionsIterator.this.extractSidecarsFromBatch(fileStatus, l, columnarBatch);
                }
                return columnarBatch;
            }
        };
    }

    public ColumnarBatch extractSidecarsFromBatch(FileStatus fileStatus, long l, ColumnarBatch columnarBatch) {
        Preconditions.checkArgument(columnarBatch.getSchema().fieldNames().contains(LogReplay.SIDECAR_FIELD_NAME));
        Path path = new Path(fileStatus.getPath()).getParent();
        ArrayList arrayList = new ArrayList();
        int n = columnarBatch.getSchema().fieldNames().indexOf(LogReplay.SIDECAR_FIELD_NAME);
        ColumnVector columnVector = columnarBatch.getColumnVector(n);
        for (int i = 0; i < columnarBatch.getSize(); ++i) {
            SidecarFile sidecarFile = SidecarFile.fromColumnVector(columnVector, i);
            if (sidecarFile == null) continue;
            FileStatus fileStatus2 = FileStatus.of(FileNames.sidecarFile(path, sidecarFile.getPath()), sidecarFile.getSizeInBytes(), sidecarFile.getModificationTime());
            this.filesList.add(DeltaLogFile.ofSideCar(fileStatus2, l));
        }
        return columnarBatch.withDeletedColumnAt(n);
    }

    private CloseableIterator<ActionWrapper> getNextActionsIter() {
        DeltaLogFile deltaLogFile = this.filesList.pop();
        FileStatus fileStatus = deltaLogFile.getFile();
        Path path = new Path(fileStatus.getPath());
        String string = path.getName();
        try {
            switch (deltaLogFile.getLogType()) {
                case COMMIT: {
                    long l = FileNames.deltaVersion(path);
                    CloseableIterator<ColumnarBatch> closeableIterator = this.engine.getJsonHandler().readJsonFiles(Utils.singletonCloseableIterator(fileStatus), this.readSchema, Optional.empty());
                    return this.combine(closeableIterator, false, l);
                }
                case CHECKPOINT_CLASSIC: 
                case V2_CHECKPOINT_MANIFEST: {
                    CloseableIterator<ColumnarBatch> closeableIterator = this.getActionsIterFromSinglePartOrV2Checkpoint(fileStatus, string);
                    long l = FileNames.checkpointVersion(path);
                    return this.combine(closeableIterator, true, l);
                }
                case MULTIPART_CHECKPOINT: 
                case SIDECAR: {
                    CloseableIterator<FileStatus> closeableIterator = this.retrieveRemainingCheckpointFiles(deltaLogFile);
                    CloseableIterator<ColumnarBatch> closeableIterator2 = this.engine.getParquetHandler().readParquetFiles(closeableIterator, this.readSchema, this.checkpointPredicate);
                    long l = FileNames.checkpointVersion(path);
                    return this.combine(closeableIterator2, true, l);
                }
            }
            throw new IOException("Unrecognized log type: " + (Object)((Object)deltaLogFile.getLogType()));
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    private CloseableIterator<ActionWrapper> combine(final CloseableIterator<ColumnarBatch> closeableIterator, final boolean bl, final long l) {
        return new CloseableIterator<ActionWrapper>(){

            @Override
            public boolean hasNext() {
                return closeableIterator.hasNext();
            }

            @Override
            public ActionWrapper next() {
                return new ActionWrapper((ColumnarBatch)closeableIterator.next(), bl, l);
            }

            @Override
            public void close() throws IOException {
                closeableIterator.close();
            }
        };
    }

    private CloseableIterator<FileStatus> retrieveRemainingCheckpointFiles(DeltaLogFile deltaLogFile) {
        ArrayList<FileStatus> arrayList = new ArrayList<FileStatus>();
        arrayList.add(deltaLogFile.getFile());
        if (deltaLogFile.getLogType() == DeltaLogFile.LogType.SIDECAR || deltaLogFile.getLogType() == DeltaLogFile.LogType.MULTIPART_CHECKPOINT) {
            DeltaLogFile deltaLogFile2 = this.filesList.peek();
            while (deltaLogFile2 != null && deltaLogFile.getLogType() == deltaLogFile2.getLogType() && deltaLogFile.getVersion() == deltaLogFile2.getVersion()) {
                arrayList.add(this.filesList.pop().getFile());
                deltaLogFile2 = this.filesList.peek();
            }
        }
        return Utils.toCloseableIterator(arrayList.iterator());
    }
}

