/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.expressions.ExpressionEvaluator;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.internal.InternalScanFileUtils;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.ActionWrapper;
import io.delta.kernel.internal.replay.LogReplay;
import io.delta.kernel.internal.replay.LogReplayUtils;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.types.StringType;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.net.URI;
import java.util.HashSet;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;

class ActiveAddFilesIterator
implements CloseableIterator<FilteredColumnarBatch> {
    private final Engine engine;
    private final Path tableRoot;
    private final CloseableIterator<ActionWrapper> iter;
    private final Set<LogReplayUtils.UniqueFileActionTuple> tombstonesFromJson;
    private final Set<LogReplayUtils.UniqueFileActionTuple> addFilesFromJson;
    private Optional<FilteredColumnarBatch> next;
    private boolean[] selectionVectorBuffer;
    private ExpressionEvaluator tableRootVectorGenerator;
    private boolean closed;

    ActiveAddFilesIterator(Engine engine, CloseableIterator<ActionWrapper> closeableIterator, Path path) {
        this.engine = engine;
        this.tableRoot = path;
        this.iter = closeableIterator;
        this.tombstonesFromJson = new HashSet<LogReplayUtils.UniqueFileActionTuple>();
        this.addFilesFromJson = new HashSet<LogReplayUtils.UniqueFileActionTuple>();
        this.next = Optional.empty();
    }

    @Override
    public boolean hasNext() {
        if (this.closed) {
            throw new IllegalStateException("Can't call `hasNext` on a closed iterator.");
        }
        if (!this.next.isPresent()) {
            this.prepareNext();
        }
        return this.next.isPresent();
    }

    @Override
    public FilteredColumnarBatch next() {
        if (this.closed) {
            throw new IllegalStateException("Can't call `next` on a closed iterator.");
        }
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        FilteredColumnarBatch filteredColumnarBatch = this.next.get();
        this.next = Optional.empty();
        return filteredColumnarBatch;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        Utils.closeCloseables(this.iter);
    }

    private void prepareNext() {
        Object object;
        Optional<ColumnVector> optional;
        Object object2;
        int n;
        ColumnVector columnVector;
        if (this.next.isPresent()) {
            return;
        }
        if (!this.iter.hasNext()) {
            return;
        }
        ActionWrapper actionWrapper = (ActionWrapper)this.iter.next();
        ColumnarBatch columnarBatch = actionWrapper.getColumnarBatch();
        boolean bl = actionWrapper.isFromCheckpoint();
        if (!bl) {
            columnVector = columnarBatch.getColumnVector(LogReplay.REMOVE_FILE_ORDINAL);
            for (n = 0; n < columnVector.getSize(); ++n) {
                if (columnVector.isNullAt(n)) continue;
                String string = ActiveAddFilesIterator.getRemoveFilePath(columnVector, n);
                object2 = LogReplayUtils.pathToUri(string);
                optional = Optional.ofNullable(ActiveAddFilesIterator.getRemoveFileDV(columnVector, n)).map(DeletionVectorDescriptor::getUniqueId);
                object = new LogReplayUtils.UniqueFileActionTuple((URI)object2, (Optional<String>)optional);
                this.tombstonesFromJson.add((LogReplayUtils.UniqueFileActionTuple)object);
            }
        }
        columnVector = columnarBatch.getColumnVector(LogReplay.ADD_FILE_ORDINAL);
        this.selectionVectorBuffer = LogReplayUtils.prepareSelectionVectorBuffer(this.selectionVectorBuffer, columnVector.getSize());
        n = 0;
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i)) {
                n = 1;
                continue;
            }
            object2 = ActiveAddFilesIterator.getAddFilePath(columnVector, i);
            optional = LogReplayUtils.pathToUri((String)object2);
            object = Optional.ofNullable(ActiveAddFilesIterator.getAddFileDV(columnVector, i)).map(DeletionVectorDescriptor::getUniqueId);
            LogReplayUtils.UniqueFileActionTuple uniqueFileActionTuple = new LogReplayUtils.UniqueFileActionTuple((URI)((Object)optional), (Optional<String>)object);
            boolean bl2 = this.tombstonesFromJson.contains(uniqueFileActionTuple);
            boolean bl3 = this.addFilesFromJson.contains(uniqueFileActionTuple);
            boolean bl4 = false;
            if (!bl3) {
                if (!bl) {
                    this.addFilesFromJson.add(uniqueFileActionTuple);
                }
                if (!bl2) {
                    bl4 = true;
                    this.selectionVectorBuffer[i] = true;
                }
            }
            if (bl4) continue;
            n = 1;
        }
        ColumnarBatch columnarBatch2 = columnarBatch.withDeletedColumnAt(1);
        if (this.tableRootVectorGenerator == null) {
            this.tableRootVectorGenerator = this.engine.getExpressionHandler().getEvaluator(columnarBatch2.getSchema(), Literal.ofString(this.tableRoot.toUri().toString()), StringType.STRING);
        }
        object2 = this.tableRootVectorGenerator.eval(columnarBatch2);
        columnarBatch2 = columnarBatch2.withNewColumn(1, InternalScanFileUtils.TABLE_ROOT_STRUCT_FIELD, (ColumnVector)object2);
        optional = n != 0 ? Optional.of(this.engine.getExpressionHandler().createSelectionVector(this.selectionVectorBuffer, 0, columnVector.getSize())) : Optional.empty();
        this.next = Optional.of(new FilteredColumnarBatch(columnarBatch2, optional));
    }

    public static String getAddFilePath(ColumnVector columnVector, int n) {
        return columnVector.getChild(LogReplay.ADD_FILE_PATH_ORDINAL).getString(n);
    }

    public static DeletionVectorDescriptor getAddFileDV(ColumnVector columnVector, int n) {
        return DeletionVectorDescriptor.fromColumnVector(columnVector.getChild(LogReplay.ADD_FILE_DV_ORDINAL), n);
    }

    public static String getRemoveFilePath(ColumnVector columnVector, int n) {
        return columnVector.getChild(LogReplay.REMOVE_FILE_PATH_ORDINAL).getString(n);
    }

    public static DeletionVectorDescriptor getRemoveFileDV(ColumnVector columnVector, int n) {
        return DeletionVectorDescriptor.fromColumnVector(columnVector.getChild(LogReplay.REMOVE_FILE_DV_ORDINAL), n);
    }
}

