/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.utils.FileStatus;

public class DeltaLogFile {
    private final FileStatus file;
    private final LogType logType;
    private final long version;

    public static DeltaLogFile forCommitOrCheckpoint(FileStatus fileStatus) {
        String string = new Path(fileStatus.getPath()).getName();
        LogType logType = null;
        long l = -1L;
        if (FileNames.isCommitFile(string)) {
            logType = LogType.COMMIT;
            l = FileNames.deltaVersion(string);
        } else if (FileNames.isClassicCheckpointFile(string)) {
            logType = LogType.CHECKPOINT_CLASSIC;
            l = FileNames.checkpointVersion(string);
        } else if (FileNames.isMulitPartCheckpointFile(string)) {
            logType = LogType.MULTIPART_CHECKPOINT;
            l = FileNames.checkpointVersion(string);
        } else if (FileNames.isV2CheckpointFile(string)) {
            logType = LogType.V2_CHECKPOINT_MANIFEST;
            l = FileNames.checkpointVersion(string);
        } else {
            throw new IllegalArgumentException("File is not a commit or checkpoint file: " + fileStatus.getPath());
        }
        return new DeltaLogFile(fileStatus, logType, l);
    }

    public static DeltaLogFile ofSideCar(FileStatus fileStatus, long l) {
        return new DeltaLogFile(fileStatus, LogType.SIDECAR, l);
    }

    private DeltaLogFile(FileStatus fileStatus, LogType logType, long l) {
        this.file = fileStatus;
        this.logType = logType;
        this.version = l;
    }

    public FileStatus getFile() {
        return this.file;
    }

    public LogType getLogType() {
        return this.logType;
    }

    public long getVersion() {
        return this.version;
    }

    public static enum LogType {
        COMMIT,
        CHECKPOINT_CLASSIC,
        MULTIPART_CHECKPOINT,
        V2_CHECKPOINT_MANIFEST,
        SIDECAR;

    }
}

