/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.util;

import io.delta.kernel.expressions.Literal;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class SchemaUtils {
    private SchemaUtils() {
    }

    public static void validateSchema(StructType structType, boolean bl) {
        Preconditions.checkArgument(structType.length() > 0, "Schema should contain at least one column");
        List<String> list = SchemaUtils.flattenNestedFieldNames(structType);
        Set set = list.stream().map(String::toLowerCase).collect(Collectors.toSet());
        if (set.size() != list.size()) {
            HashSet hashSet = new HashSet();
            List<String> list2 = list.stream().map(String::toLowerCase).filter(string -> !hashSet.add(string)).collect(Collectors.toList());
            throw DeltaErrors.duplicateColumnsInSchema(structType, list2);
        }
        if (!bl) {
            SchemaUtils.validParquetColumnNames(list);
        } else {
            list.forEach(string -> {
                if (string.contains("\\n")) {
                    throw DeltaErrors.invalidColumnName(string, "\\n");
                }
            });
        }
        SchemaUtils.validateSupportedType(structType);
    }

    public static void validatePartitionColumns(StructType structType, List<String> list) {
        Map<String, DataType> map = structType.fields().stream().collect(Collectors.toMap(structField -> structField.getName().toLowerCase(Locale.ROOT), StructField::getDataType));
        list.stream().forEach(string -> {
            DataType dataType = (DataType)map.get(string.toLowerCase(Locale.ROOT));
            Preconditions.checkArgument(dataType != null, "Partition column " + string + " not found in the schema");
            if (!(dataType instanceof BooleanType || dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof LongType || dataType instanceof FloatType || dataType instanceof DoubleType || dataType instanceof DecimalType || dataType instanceof StringType || dataType instanceof BinaryType || dataType instanceof DateType || dataType instanceof TimestampType)) {
                throw DeltaErrors.unsupportedPartitionDataType(string, dataType);
            }
        });
    }

    public static List<String> casePreservingPartitionColNames(StructType structType, List<String> list) {
        HashMap hashMap = new HashMap();
        structType.fieldNames().forEach(string -> hashMap.put(string.toLowerCase(Locale.ROOT), string));
        return list.stream().map(string -> (String)hashMap.get(string.toLowerCase(Locale.ROOT))).collect(Collectors.toList());
    }

    public static Map<String, Literal> casePreservingPartitionColNames(List<String> list, Map<String, Literal> map) {
        HashMap hashMap = new HashMap();
        list.forEach(string -> hashMap.put(string.toLowerCase(Locale.ROOT), string));
        return map.entrySet().stream().collect(Collectors.toMap(entry -> (String)hashMap.get(((String)entry.getKey()).toLowerCase(Locale.ROOT)), Map.Entry::getValue));
    }

    public static int findColIndex(StructType structType, String string) {
        for (int i = 0; i < structType.length(); ++i) {
            if (!structType.at(i).getName().equalsIgnoreCase(string)) continue;
            return i;
        }
        return -1;
    }

    private static List<String> flattenNestedFieldNames(StructType structType) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (StructField structField : structType.fields()) {
            String string = SchemaUtils.escapeDots(structField.getName());
            arrayList.add(string);
            arrayList.addAll(SchemaUtils.flattenNestedFieldNamesRecursive(string, structField.getDataType()));
        }
        return arrayList;
    }

    private static List<String> flattenNestedFieldNamesRecursive(String string, DataType dataType) {
        ArrayList<String> arrayList = new ArrayList<String>();
        if (dataType instanceof StructType) {
            for (StructField structField : ((StructType)dataType).fields()) {
                String string2 = SchemaUtils.escapeDots(structField.getName());
                arrayList.add(string + "." + string2);
                arrayList.addAll(SchemaUtils.flattenNestedFieldNamesRecursive(string + "." + string2, structField.getDataType()));
            }
        } else if (dataType instanceof ArrayType) {
            arrayList.addAll(SchemaUtils.flattenNestedFieldNamesRecursive(string + ".element", ((ArrayType)dataType).getElementType()));
        } else if (dataType instanceof MapType) {
            MapType mapType = (MapType)dataType;
            arrayList.addAll(SchemaUtils.flattenNestedFieldNamesRecursive(string + ".key", mapType.getKeyType()));
            arrayList.addAll(SchemaUtils.flattenNestedFieldNamesRecursive(string + ".value", mapType.getValueType()));
        }
        return arrayList;
    }

    private static String escapeDots(String string) {
        return string.contains(".") ? "`" + string + "`" : string;
    }

    protected static void validParquetColumnNames(List<String> list) {
        for (String string : list) {
            if (!string.matches(".*[ ,;{}()\n\t=].*")) continue;
            throw DeltaErrors.invalidColumnName(string, "[ ,;{}()\\n\\t=]");
        }
    }

    protected static void validateSupportedType(DataType dataType) {
        if (dataType instanceof BooleanType || dataType instanceof ByteType || dataType instanceof ShortType || dataType instanceof IntegerType || dataType instanceof LongType || dataType instanceof FloatType || dataType instanceof DoubleType || dataType instanceof DecimalType || dataType instanceof StringType || dataType instanceof BinaryType || dataType instanceof DateType || dataType instanceof TimestampType) {
            return;
        }
        if (dataType instanceof StructType) {
            ((StructType)dataType).fields().forEach(structField -> SchemaUtils.validateSupportedType(structField.getDataType()));
        } else if (dataType instanceof ArrayType) {
            SchemaUtils.validateSupportedType(((ArrayType)dataType).getElementType());
        } else if (dataType instanceof MapType) {
            SchemaUtils.validateSupportedType(((MapType)dataType).getKeyType());
            SchemaUtils.validateSupportedType(((MapType)dataType).getValueType());
        } else {
            throw DeltaErrors.unsupportedDataType(dataType);
        }
    }
}

