/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.checkpoints;

import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.KernelEngineException;
import io.delta.kernel.internal.checkpoints.CheckpointInstance;
import io.delta.kernel.internal.checkpoints.CheckpointMetaData;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Checkpointer {
    private static final Logger logger = LoggerFactory.getLogger(Checkpointer.class);
    public static final String LAST_CHECKPOINT_FILE_NAME = "_last_checkpoint";
    private final Path lastCheckpointFilePath;

    public static Optional<CheckpointInstance> getLatestCompleteCheckpointFromList(List<CheckpointInstance> list, CheckpointInstance checkpointInstance3) {
        List list2 = list.stream().filter(checkpointInstance2 -> checkpointInstance2.isNotLaterThan(checkpointInstance3)).collect(Collectors.groupingBy(checkpointInstance -> checkpointInstance)).entrySet().stream().filter(entry -> {
            CheckpointInstance checkpointInstance = (CheckpointInstance)entry.getKey();
            List list = (List)entry.getValue();
            if (checkpointInstance.numParts.isPresent()) {
                return list.size() == ((CheckpointInstance)entry.getKey()).numParts.get().intValue();
            }
            return list.size() == 1;
        }).map(Map.Entry::getKey).collect(Collectors.toList());
        if (list2.isEmpty()) {
            return Optional.empty();
        }
        return Optional.of(Collections.max(list2));
    }

    public static Optional<CheckpointInstance> findLastCompleteCheckpointBefore(Engine engine, Path path, long l) {
        return (Optional)Checkpointer.findLastCompleteCheckpointBeforeHelper((Engine)engine, (Path)path, (long)l)._1;
    }

    protected static Tuple2<Optional<CheckpointInstance>, Long> findLastCompleteCheckpointBeforeHelper(Engine engine, Path path, long l) {
        CheckpointInstance checkpointInstance = new CheckpointInstance(l);
        logger.info("Try to find the last complete checkpoint before version {}", (Object)l);
        long l2 = 0L;
        for (long i = l; i >= 0L; i -= 1000L) {
            try {
                Object object;
                long l3 = Math.max(0L, i - 1000L);
                CloseableIterator<FileStatus> closeableIterator = engine.getFileSystemClient().listFrom(FileNames.listingPrefix(path, l3));
                ArrayList<CheckpointInstance> arrayList = new ArrayList<CheckpointInstance>();
                while (closeableIterator.hasNext()) {
                    boolean bl;
                    object = closeableIterator.next();
                    String string = new Path(((FileStatus)object).getPath()).getName();
                    long l4 = FileNames.isCommitFile(string) ? FileNames.deltaVersion(string) : (FileNames.isCheckpointFile(string) ? FileNames.checkpointVersion(string) : i);
                    boolean bl2 = bl = (i == 0L || l4 <= i) && l4 < l;
                    if (!bl) break;
                    if (Checkpointer.validCheckpointFile((FileStatus)object)) {
                        arrayList.add(new CheckpointInstance(((FileStatus)object).getPath()));
                    }
                    ++l2;
                }
                if (!((Optional)(object = Checkpointer.getLatestCompleteCheckpointFromList(arrayList, checkpointInstance))).isPresent()) continue;
                logger.info("Found the last complete checkpoint before version {} at {}", (Object)l, ((Optional)object).get());
                return new Tuple2<Object, Long>(object, l2);
            }
            catch (IOException iOException) {
                String string = String.format("Failed to list checkpoint files for version %s in %s.", l, path);
                logger.warn(string, (Throwable)iOException);
                return new Tuple2<Optional<CheckpointInstance>, Long>(Optional.empty(), l2);
            }
        }
        logger.info("No complete checkpoint found before version {} in {}", (Object)l, (Object)path);
        return new Tuple2<Optional<CheckpointInstance>, Long>(Optional.empty(), l2);
    }

    private static boolean validCheckpointFile(FileStatus fileStatus) {
        return FileNames.isCheckpointFile(new Path(fileStatus.getPath()).getName()) && fileStatus.getSize() > 0L;
    }

    public Checkpointer(Path path) {
        this.lastCheckpointFilePath = new Path(path, LAST_CHECKPOINT_FILE_NAME);
    }

    public Optional<CheckpointMetaData> readLastCheckpointFile(Engine engine) {
        return this.loadMetadataFromFile(engine, 0);
    }

    public void writeLastCheckpointFile(Engine engine, CheckpointMetaData checkpointMetaData) throws IOException {
        engine.getJsonHandler().writeJsonFileAtomically(this.lastCheckpointFilePath.toString(), Utils.singletonCloseableIterator(checkpointMetaData.toRow()), true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Optional<CheckpointMetaData> loadMetadataFromFile(Engine engine, int n) {
        if (n >= 3) {
            logger.warn("Failed to load checkpoint metadata from file {} after 3 attempts.", (Object)this.lastCheckpointFilePath);
            return Optional.empty();
        }
        try {
            FileStatus fileStatus = FileStatus.of(this.lastCheckpointFilePath.toString(), 0L, 0L);
            try (CloseableIterator<ColumnarBatch> closeableIterator = engine.getJsonHandler().readJsonFiles(Utils.singletonCloseableIterator(fileStatus), CheckpointMetaData.READ_SCHEMA, Optional.empty());){
                Optional<Row> optional = InternalUtils.getSingularRow(closeableIterator);
                if (optional.isPresent()) {
                    Optional<CheckpointMetaData> optional2 = Optional.of(CheckpointMetaData.fromRow(optional.get()));
                    return optional2;
                }
                logger.warn("Last checkpoint file {} has no data. Retrying after 1sec. (current attempt = {})", (Object)this.lastCheckpointFilePath, (Object)n);
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException interruptedException) {
                    Thread.currentThread().interrupt();
                    Optional<CheckpointMetaData> optional3 = Optional.empty();
                    if (closeableIterator == null) return optional3;
                    if (var5_8 == null) {
                        closeableIterator.close();
                        return optional3;
                    }
                    try {
                        closeableIterator.close();
                        return optional3;
                    }
                    catch (Throwable throwable) {
                        var5_8.addSuppressed(throwable);
                        return optional3;
                    }
                }
                Optional<CheckpointMetaData> optional4 = this.loadMetadataFromFile(engine, n + 1);
                return optional4;
            }
        }
        catch (IOException iOException) {
            return Optional.empty();
        }
        catch (KernelEngineException kernelEngineException) {
            Throwable throwable = kernelEngineException.getCause();
            if (throwable instanceof FileNotFoundException) {
                return Optional.empty();
            }
            if (!(throwable instanceof Exception)) throw kernelEngineException;
            String string = String.format("Failed to load checkpoint metadata from file %s. It must be in the process of being written. Retrying after 1sec. (current attempt of %s (max 3)", this.lastCheckpointFilePath, n);
            logger.warn(string, throwable);
            return this.loadMetadataFromFile(engine, n + 1);
        }
    }
}

