/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.FilteredColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.internal.actions.SetTransaction;
import io.delta.kernel.internal.actions.SingleAction;
import io.delta.kernel.internal.replay.ActionWrapper;
import io.delta.kernel.internal.replay.ActionsIterator;
import io.delta.kernel.internal.replay.LogReplayUtils;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;

public class CreateCheckpointIterator
implements CloseableIterator<FilteredColumnarBatch> {
    private static final int[] ADD_ORDINAL = LogReplayUtils.getPathOrdinals(SingleAction.CHECKPOINT_SCHEMA, "add");
    private static final int[] ADD_PATH_ORDINAL = LogReplayUtils.getPathOrdinals(SingleAction.CHECKPOINT_SCHEMA, "add", "path");
    private static final int[] ADD_DV_ORDINAL = LogReplayUtils.getPathOrdinals(SingleAction.CHECKPOINT_SCHEMA, "add", "deletionVector");
    private static final int[] REMOVE_ORDINAL = LogReplayUtils.getPathOrdinals(SingleAction.CHECKPOINT_SCHEMA, "remove");
    private static final int[] REMOVE_PATH_ORDINAL = LogReplayUtils.getPathOrdinals(SingleAction.CHECKPOINT_SCHEMA, "remove", "path");
    private static final int[] REMOVE_DV_ORDINAL = LogReplayUtils.getPathOrdinals(SingleAction.CHECKPOINT_SCHEMA, "remove", "deletionVector");
    private static final int[] REMOVE_DELETE_TIMESTAMP_ORDINAL = LogReplayUtils.getPathOrdinals(SingleAction.CHECKPOINT_SCHEMA, "remove", "deletionTimestamp");
    private static final int[] PROTOCOL_ORDINAL = LogReplayUtils.getPathOrdinals(SingleAction.CHECKPOINT_SCHEMA, "protocol");
    private static final int[] METADATA_ORDINAL = LogReplayUtils.getPathOrdinals(SingleAction.CHECKPOINT_SCHEMA, "metaData");
    private static final int[] TXN_ORDINAL = LogReplayUtils.getPathOrdinals(SingleAction.CHECKPOINT_SCHEMA, "txn");
    private final Engine engine;
    private final LogSegment logSegment;
    private final long minFileRetentionTimestampMillis;
    private CloseableIterator<ActionWrapper> actionsIter;
    private boolean closed;
    private Optional<FilteredColumnarBatch> toReturnNext = Optional.empty();
    private boolean[] selectionVectorBuffer;
    private final Set<LogReplayUtils.UniqueFileActionTuple> tombstonesFromJson = new HashSet<LogReplayUtils.UniqueFileActionTuple>();
    private final Set<LogReplayUtils.UniqueFileActionTuple> addFilesFromJson = new HashSet<LogReplayUtils.UniqueFileActionTuple>();
    private boolean isMetadataAlreadySeen;
    private boolean isProtocolAlreadySeen;
    private final Map<String, Long> txnAppIdToVersion = new HashMap<String, Long>();
    private long numberOfAddActions = 0L;

    public CreateCheckpointIterator(Engine engine, LogSegment logSegment, long l) {
        this.engine = engine;
        this.logSegment = logSegment;
        this.minFileRetentionTimestampMillis = l;
    }

    @Override
    public boolean hasNext() {
        this.initActionIterIfRequired();
        Preconditions.checkState(!this.closed, "Can't call `hasNext` on a closed iterator.");
        return this.prepareNext();
    }

    @Override
    public FilteredColumnarBatch next() {
        Preconditions.checkState(!this.closed, "Can't call `next` on a closed iterator.");
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        FilteredColumnarBatch filteredColumnarBatch = this.toReturnNext.get();
        this.toReturnNext = Optional.empty();
        return filteredColumnarBatch;
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        Utils.closeCloseables(this.actionsIter);
    }

    public long getNumberOfAddActions() {
        Preconditions.checkState(this.closed, "Iterator is not fully consumed yet.");
        return this.numberOfAddActions;
    }

    private void initActionIterIfRequired() {
        if (this.actionsIter == null) {
            this.actionsIter = new ActionsIterator(this.engine, this.logSegment.allLogFilesReversed(), SingleAction.CHECKPOINT_SCHEMA, Optional.empty());
        }
    }

    private boolean prepareNext() {
        if (this.toReturnNext.isPresent()) {
            return true;
        }
        if (!this.actionsIter.hasNext()) {
            return false;
        }
        ActionWrapper actionWrapper = this.actionsIter.next();
        ColumnarBatch columnarBatch = actionWrapper.getColumnarBatch();
        boolean bl = actionWrapper.isFromCheckpoint();
        this.selectionVectorBuffer = LogReplayUtils.prepareSelectionVectorBuffer(this.selectionVectorBuffer, columnarBatch.getSize());
        if (!bl) {
            this.processRemoves(LogReplayUtils.getVector(columnarBatch, REMOVE_ORDINAL), LogReplayUtils.getVector(columnarBatch, REMOVE_PATH_ORDINAL), LogReplayUtils.getVector(columnarBatch, REMOVE_DV_ORDINAL), LogReplayUtils.getVector(columnarBatch, REMOVE_DELETE_TIMESTAMP_ORDINAL), this.selectionVectorBuffer);
        }
        this.processAdds(LogReplayUtils.getVector(columnarBatch, ADD_ORDINAL), LogReplayUtils.getVector(columnarBatch, ADD_PATH_ORDINAL), LogReplayUtils.getVector(columnarBatch, ADD_DV_ORDINAL), bl, this.selectionVectorBuffer);
        ColumnVector columnVector = LogReplayUtils.getVector(columnarBatch, PROTOCOL_ORDINAL);
        this.processProtocol(columnVector, this.selectionVectorBuffer);
        ColumnVector columnVector2 = LogReplayUtils.getVector(columnarBatch, METADATA_ORDINAL);
        this.processMetadata(columnVector2, this.selectionVectorBuffer);
        ColumnVector columnVector3 = LogReplayUtils.getVector(columnarBatch, TXN_ORDINAL);
        this.processTxn(columnVector3, this.selectionVectorBuffer);
        Optional<ColumnVector> optional = Optional.of(this.createSelectionVector(this.selectionVectorBuffer, columnarBatch.getSize()));
        this.toReturnNext = Optional.of(new FilteredColumnarBatch(columnarBatch, optional));
        return true;
    }

    private void processRemoves(ColumnVector columnVector, ColumnVector columnVector2, ColumnVector columnVector3, ColumnVector columnVector4, boolean[] blArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i)) continue;
            LogReplayUtils.UniqueFileActionTuple uniqueFileActionTuple = LogReplayUtils.getUniqueFileAction(columnVector2, columnVector3, i);
            this.tombstonesFromJson.add(uniqueFileActionTuple);
            long l = 0L;
            if (!columnVector4.isNullAt(i)) {
                l = columnVector4.getLong(i);
            }
            if (l <= this.minFileRetentionTimestampMillis) continue;
            this.select(blArray, i);
        }
    }

    private void processAdds(ColumnVector columnVector, ColumnVector columnVector2, ColumnVector columnVector3, boolean bl, boolean[] blArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i)) continue;
            LogReplayUtils.UniqueFileActionTuple uniqueFileActionTuple = LogReplayUtils.getUniqueFileAction(columnVector2, columnVector3, i);
            boolean bl2 = this.tombstonesFromJson.contains(uniqueFileActionTuple);
            boolean bl3 = this.addFilesFromJson.contains(uniqueFileActionTuple);
            if (bl3) continue;
            if (!bl) {
                this.addFilesFromJson.add(uniqueFileActionTuple);
            }
            if (bl2) continue;
            ++this.numberOfAddActions;
            this.select(blArray, i);
        }
    }

    private void processProtocol(ColumnVector columnVector, boolean[] blArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i)) continue;
            if (this.isProtocolAlreadySeen) {
                this.unselect(blArray, i);
                continue;
            }
            this.select(blArray, i);
            this.isProtocolAlreadySeen = true;
        }
    }

    private void processMetadata(ColumnVector columnVector, boolean[] blArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i)) continue;
            if (this.isMetadataAlreadySeen) {
                this.unselect(blArray, i);
                continue;
            }
            this.select(blArray, i);
            this.isMetadataAlreadySeen = true;
        }
    }

    private void processTxn(ColumnVector columnVector, boolean[] blArray) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            SetTransaction setTransaction = SetTransaction.fromColumnVector(columnVector, i);
            if (setTransaction == null) continue;
            if (this.txnAppIdToVersion.containsKey(setTransaction.getAppId())) {
                this.unselect(blArray, i);
                continue;
            }
            this.select(blArray, i);
            this.txnAppIdToVersion.put(setTransaction.getAppId(), setTransaction.getVersion());
        }
    }

    private void unselect(boolean[] blArray, int n) {
        assert (!blArray[n]) : "Row is already marked for selection, can't unselect now: " + n;
        blArray[n] = false;
    }

    private void select(boolean[] blArray, int n) {
        blArray[n] = true;
    }

    private ColumnVector createSelectionVector(boolean[] blArray, int n) {
        return this.engine.getExpressionHandler().createSelectionVector(blArray, 0, n);
    }
}

