/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.data;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.internal.deletionvectors.RoaringBitmapArray;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;

public class SelectionColumnVector
implements ColumnVector {
    private final RoaringBitmapArray bitmap;
    private final ColumnVector rowIndices;

    public SelectionColumnVector(RoaringBitmapArray roaringBitmapArray, ColumnVector columnVector) {
        this.bitmap = roaringBitmapArray;
        this.rowIndices = columnVector;
    }

    @Override
    public DataType getDataType() {
        return BooleanType.BOOLEAN;
    }

    @Override
    public int getSize() {
        return this.rowIndices.getSize();
    }

    @Override
    public void close() {
        this.rowIndices.close();
    }

    @Override
    public boolean isNullAt(int n) {
        return false;
    }

    @Override
    public boolean getBoolean(int n) {
        return !this.bitmap.contains(this.rowIndices.getLong(n));
    }
}

