/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Operation;
import io.delta.kernel.Transaction;
import io.delta.kernel.TransactionCommitResult;
import io.delta.kernel.data.Row;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.ConcurrentWriteException;
import io.delta.kernel.expressions.Column;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.CommitInfo;
import io.delta.kernel.internal.actions.DomainMetadata;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.actions.SetTransaction;
import io.delta.kernel.internal.actions.SingleAction;
import io.delta.kernel.internal.data.TransactionStateRow;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.replay.ConflictChecker;
import io.delta.kernel.internal.util.Clock;
import io.delta.kernel.internal.util.ColumnMapping;
import io.delta.kernel.internal.util.DomainMetadataUtils;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.InCommitTimestampUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterable;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TransactionImpl
implements Transaction {
    private static final Logger logger = LoggerFactory.getLogger(TransactionImpl.class);
    public static final int DEFAULT_READ_VERSION = 1;
    public static final int DEFAULT_WRITE_VERSION = 2;
    private static final int NUM_TXN_RETRIES = 200;
    private final UUID txnId = UUID.randomUUID();
    private final boolean isNewTable;
    private final String engineInfo;
    private final Operation operation;
    private final Path dataPath;
    private final Path logPath;
    private final Protocol protocol;
    private final SnapshotImpl readSnapshot;
    private final Optional<SetTransaction> setTxnOpt;
    private final boolean shouldUpdateProtocol;
    private final Clock clock;
    private final List<DomainMetadata> domainMetadatas = new ArrayList<DomainMetadata>();
    private Metadata metadata;
    private boolean shouldUpdateMetadata;
    private boolean closed;

    public TransactionImpl(boolean bl, Path path, Path path2, SnapshotImpl snapshotImpl, String string, Operation operation, Protocol protocol, Metadata metadata, Optional<SetTransaction> optional, boolean bl2, boolean bl3, Clock clock) {
        this.isNewTable = bl;
        this.dataPath = path;
        this.logPath = path2;
        this.readSnapshot = snapshotImpl;
        this.engineInfo = string;
        this.operation = operation;
        this.protocol = protocol;
        this.metadata = metadata;
        this.setTxnOpt = optional;
        this.shouldUpdateMetadata = bl2;
        this.shouldUpdateProtocol = bl3;
        this.clock = clock;
    }

    @Override
    public Row getTransactionState(Engine engine) {
        return TransactionStateRow.of(this.metadata, this.dataPath.toString());
    }

    @Override
    public List<String> getPartitionColumns(Engine engine) {
        return VectorUtils.toJavaList(this.metadata.getPartitionColumns());
    }

    @Override
    public StructType getSchema(Engine engine) {
        return this.readSnapshot.getSchema(engine);
    }

    public Optional<SetTransaction> getSetTxnOpt() {
        return this.setTxnOpt;
    }

    public void addDomainMetadatas(List<DomainMetadata> list) {
        this.domainMetadatas.addAll(list);
    }

    public List<DomainMetadata> getDomainMetadatas() {
        return this.domainMetadatas;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public TransactionCommitResult commit(Engine engine, CloseableIterable<Row> closeableIterable) throws ConcurrentWriteException {
        Preconditions.checkState(!this.closed, "Transaction is already attempted to commit. Create a new transaction.");
        long l = this.readSnapshot.getVersion(engine) + 1L;
        CommitInfo commitInfo = this.generateCommitAction(engine);
        this.updateMetadataWithICTIfRequired(engine, commitInfo.getInCommitTimestamp(), this.readSnapshot.getVersion(engine));
        int n = 0;
        while (true) {
            logger.info("Committing transaction as version = {}.", (Object)l);
            try {
                TransactionCommitResult transactionCommitResult = this.doCommit(engine, l, commitInfo, closeableIterable);
                this.closed = true;
                return transactionCommitResult;
            }
            catch (FileAlreadyExistsException fileAlreadyExistsException) {
                try {
                    logger.info("Concurrent write detected when committing as version = {}. Trying to resolve conflicts and retry commit.", (Object)l);
                    ConflictChecker.TransactionRebaseState transactionRebaseState = ConflictChecker.resolveConflicts(engine, this.readSnapshot, l, this);
                    long l2 = transactionRebaseState.getLatestVersion() + 1L;
                    Preconditions.checkArgument(l < l2, "New commit version %d should be greater than the previous commit attempt version %d.", l2, l);
                    l = l2;
                    Optional<Long> optional = this.getUpdatedInCommitTimestampAfterConflict(transactionRebaseState.getLatestCommitTimestamp(), commitInfo.getInCommitTimestamp());
                    this.updateMetadataWithICTIfRequired(engine, optional, transactionRebaseState.getLatestVersion());
                    commitInfo.setInCommitTimestamp(optional);
                    if (++n < 200) continue;
                    this.closed = true;
                }
                catch (Throwable throwable) {
                    this.closed = true;
                    throw throwable;
                }
            }
            break;
        }
        logger.info("Exhausted maximum retries ({}) for committing transaction.", (Object)200);
        throw new ConcurrentWriteException();
    }

    private void updateMetadata(Metadata metadata) {
        logger.info("Updated metadata from {} to {}", this.shouldUpdateMetadata ? this.metadata : "-", (Object)metadata);
        this.metadata = metadata;
        this.shouldUpdateMetadata = true;
    }

    private void updateMetadataWithICTIfRequired(Engine engine, Optional<Long> optional, long l) {
        optional.ifPresent(l2 -> {
            Optional<Metadata> optional = InCommitTimestampUtils.getUpdatedMetadataWithICTEnablementInfo(engine, l2, this.readSnapshot, this.metadata, l + 1L);
            optional.ifPresent(this::updateMetadata);
        });
    }

    private Optional<Long> getUpdatedInCommitTimestampAfterConflict(long l, Optional<Long> optional) {
        if (optional.isPresent()) {
            long l2 = Math.max(optional.get(), l + 1L);
            return Optional.of(l2);
        }
        return optional;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private TransactionCommitResult doCommit(Engine engine, long l, CommitInfo commitInfo, CloseableIterable<Row> closeableIterable) throws FileAlreadyExistsException {
        ArrayList<Row> arrayList = new ArrayList<Row>();
        arrayList.add(SingleAction.createCommitInfoSingleAction(commitInfo.toRow()));
        if (this.shouldUpdateMetadata || this.isNewTable) {
            this.metadata = ColumnMapping.updateColumnMappingMetadata(this.metadata, ColumnMapping.getColumnMappingMode(this.metadata.getConfiguration()), this.isNewTable);
            arrayList.add(SingleAction.createMetadataSingleAction(this.metadata.toRow()));
        }
        if (this.shouldUpdateProtocol || this.isNewTable) {
            arrayList.add(SingleAction.createProtocolSingleAction(this.protocol.toRow()));
        }
        this.setTxnOpt.ifPresent(setTransaction -> arrayList.add(SingleAction.createTxnSingleAction(setTransaction.toRow())));
        DomainMetadataUtils.validateDomainMetadatas(this.domainMetadatas, this.protocol);
        this.domainMetadatas.forEach(domainMetadata -> arrayList.add(SingleAction.createDomainMetadataSingleAction(domainMetadata.toRow())));
        try (Iterator iterator = closeableIterable.iterator();){
            CloseableIterator closeableIterator = Utils.toCloseableIterator(arrayList.iterator()).combine(iterator);
            if (l == 0L && !DeltaErrors.wrapEngineExceptionThrowsIO(() -> engine.getFileSystemClient().mkdirs(this.logPath.toString()), "Creating directories for path %s", this.logPath).booleanValue()) {
                throw new RuntimeException("Failed to create delta log directory: " + this.logPath);
            }
            DeltaErrors.wrapEngineExceptionThrowsIO(() -> {
                engine.getJsonHandler().writeJsonFileAtomically(FileNames.deltaFile(this.logPath, l), closeableIterator, false);
                return null;
            }, "Write file actions to JSON log file `%s`", FileNames.deltaFile(this.logPath, l));
            TransactionCommitResult transactionCommitResult = new TransactionCommitResult(l, this.isReadyForCheckpoint(l));
            return transactionCommitResult;
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            throw fileAlreadyExistsException;
        }
        catch (IOException iOException) {
            throw new UncheckedIOException(iOException);
        }
    }

    public boolean isBlindAppend() {
        return true;
    }

    private Optional<Long> generateInCommitTimestampForFirstCommitAttempt(Engine engine, long l) {
        if (TableConfig.IN_COMMIT_TIMESTAMPS_ENABLED.fromMetadata(this.metadata).booleanValue()) {
            long l2 = this.readSnapshot.getTimestamp(engine);
            return Optional.of(Math.max(l, l2 + 1L));
        }
        return Optional.empty();
    }

    private CommitInfo generateCommitAction(Engine engine) {
        long l = this.clock.getTimeMillis();
        return new CommitInfo(this.generateInCommitTimestampForFirstCommitAttempt(engine, l), l, "Kernel-3.3.2/" + this.engineInfo, this.operation.getDescription(), this.getOperationParameters(), this.isBlindAppend(), this.txnId.toString(), Collections.emptyMap());
    }

    private boolean isReadyForCheckpoint(long l) {
        int n = TableConfig.CHECKPOINT_INTERVAL.fromMetadata(this.metadata);
        return l > 0L && l % (long)n == 0L;
    }

    private Map<String, String> getOperationParameters() {
        if (this.isNewTable) {
            List list = VectorUtils.toJavaList(this.metadata.getPartitionColumns());
            String string2 = list.stream().map(string -> "\"" + string + "\"").collect(Collectors.joining(",", "[", "]"));
            return Collections.singletonMap("partitionBy", string2);
        }
        return Collections.emptyMap();
    }

    public static List<Column> getStatisticsColumns(Engine engine, Row row) {
        return Collections.emptyList();
    }
}

