/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.InvalidTableException;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.expressions.ExpressionEvaluator;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.DeltaHistoryManager;
import io.delta.kernel.internal.actions.AddCDCFile;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.CommitInfo;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.actions.RemoveFile;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.ListUtils;
import io.delta.kernel.internal.replay.ActionsIterator;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.StructField;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DeltaLogActionUtils {
    private static final Logger logger = LoggerFactory.getLogger(DeltaLogActionUtils.class);
    private static final String COMMIT_VERSION_COL_NAME = "version";
    private static final DataType COMMIT_VERSION_DATA_TYPE = LongType.LONG;
    private static final StructField COMMIT_VERSION_STRUCT_FIELD = new StructField("version", COMMIT_VERSION_DATA_TYPE, false);
    private static final String COMMIT_TIMESTAMP_COL_NAME = "timestamp";
    private static final DataType COMMIT_TIMESTAMP_DATA_TYPE = LongType.LONG;
    private static final StructField COMMIT_TIMESTAMP_STRUCT_FIELD = new StructField("timestamp", COMMIT_TIMESTAMP_DATA_TYPE, false);

    private DeltaLogActionUtils() {
    }

    public static List<FileStatus> getCommitFilesForVersionRange(Engine engine, Path path, long l, long l2) {
        if (l < 0L || l2 < l) {
            throw DeltaErrors.invalidVersionRange(l, l2);
        }
        List<FileStatus> list = DeltaLogActionUtils.listDeltaLogFilesAsIter(engine, Collections.singleton(FileNames.DeltaLogFileType.COMMIT), path, l, Optional.of(l2), false).toInMemoryList();
        if (list.isEmpty()) {
            throw DeltaErrors.noCommitFilesFoundForVersionRange(path.toString(), l, l2);
        }
        DeltaLogActionUtils.verifyDeltaVersions(list, l, l2, path);
        return list;
    }

    public static CloseableIterator<ColumnarBatch> readCommitFiles(Engine engine, List<FileStatus> list, StructType structType) {
        return new ActionsIterator(engine, list, structType, Optional.empty()).map(actionWrapper -> {
            long l = actionWrapper.getTimestamp().orElseThrow(() -> new RuntimeException("Commit files should always have a timestamp"));
            ExpressionEvaluator expressionEvaluator = DeltaErrors.wrapEngineException(() -> engine.getExpressionHandler().getEvaluator(structType, Literal.ofLong(actionWrapper.getVersion()), LongType.LONG), "Get the expression evaluator for the commit version", new Object[0]);
            ExpressionEvaluator expressionEvaluator2 = DeltaErrors.wrapEngineException(() -> engine.getExpressionHandler().getEvaluator(structType, Literal.ofLong(l), LongType.LONG), "Get the expression evaluator for the commit timestamp", new Object[0]);
            ColumnVector columnVector = DeltaErrors.wrapEngineException(() -> expressionEvaluator.eval(actionWrapper.getColumnarBatch()), "Evaluating the commit version expression", new Object[0]);
            ColumnVector columnVector2 = DeltaErrors.wrapEngineException(() -> expressionEvaluator2.eval(actionWrapper.getColumnarBatch()), "Evaluating the commit timestamp expression", new Object[0]);
            return actionWrapper.getColumnarBatch().withNewColumn(0, COMMIT_VERSION_STRUCT_FIELD, columnVector).withNewColumn(1, COMMIT_TIMESTAMP_STRUCT_FIELD, columnVector2);
        });
    }

    public static CloseableIterator<FileStatus> listDeltaLogFilesAsIter(Engine engine, Set<FileNames.DeltaLogFileType> set, Path path, long l, Optional<Long> optional, boolean bl) {
        Preconditions.checkArgument(!set.isEmpty(), "At least one file type must be provided");
        optional.ifPresent(l2 -> Preconditions.checkArgument(l2 >= l, "endVersion=%s provided is less than startVersion=%s", l2, l));
        Path path2 = new Path(path, "_delta_log");
        logger.info("Listing log files types={} in path={} starting from {} and ending with {}", new Object[]{set, path2, l, optional});
        AtomicBoolean atomicBoolean = new AtomicBoolean(false);
        return DeltaLogActionUtils.listLogDir(engine, path, l).breakableFilter(fileStatus -> {
            long l2;
            long l3;
            String string = Path.getName(fileStatus.getPath());
            if (!(set.contains((Object)FileNames.DeltaLogFileType.COMMIT) && FileNames.isCommitFile(string) || set.contains((Object)FileNames.DeltaLogFileType.LOG_COMPACTION) && FileNames.isLogCompactionFile(string) || set.contains((Object)FileNames.DeltaLogFileType.CHECKPOINT) && FileNames.isCheckpointFile(string) && fileStatus.getSize() > 0L || set.contains((Object)FileNames.DeltaLogFileType.CHECKSUM) && FileNames.isChecksumFile(string))) {
                logger.debug("Ignoring file {} as it is not of the desired type", (Object)fileStatus.getPath());
                return CloseableIterator.BreakableFilterResult.EXCLUDE;
            }
            if (FileNames.isLogCompactionFile(string)) {
                Tuple2<Long, Long> tuple2 = FileNames.logCompactionVersions(new Path(fileStatus.getPath()));
                l3 = (Long)tuple2._1;
                if (optional.isPresent()) {
                    long l4 = (Long)optional.get();
                    if ((Long)tuple2._2 > l4) {
                        logger.debug("Excluding compaction file as it covers past the end version {}", (Object)string);
                        return CloseableIterator.BreakableFilterResult.EXCLUDE;
                    }
                }
            } else {
                l3 = FileNames.getFileVersion(new Path(fileStatus.getPath()));
            }
            if (l3 < l) {
                throw new RuntimeException(String.format("Listing files in %s with startVersion %s yet found file %s.", path2, l, fileStatus.getPath()));
            }
            if (optional.isPresent() && l3 > (l2 = ((Long)optional.get()).longValue())) {
                if (bl && !atomicBoolean.get()) {
                    long l5 = DeltaHistoryManager.getEarliestRecreatableCommit(engine, path2);
                    throw DeltaErrors.versionBeforeFirstAvailableCommit(path.toString(), l2, l5);
                }
                logger.debug("Stopping listing; found file {} with version greater than endVersion {}", (Object)fileStatus.getPath(), (Object)l2);
                return CloseableIterator.BreakableFilterResult.BREAK;
            }
            if (FileNames.isCommitFile(string) || FileNames.isCheckpointFile(string) || FileNames.isLogCompactionFile(string)) {
                atomicBoolean.set(true);
            }
            return CloseableIterator.BreakableFilterResult.INCLUDE;
        });
    }

    static void verifyDeltaVersions(List<FileStatus> list, long l, long l2, Path path) {
        List list2 = list.stream().map(fileStatus -> FileNames.deltaVersion(new Path(fileStatus.getPath()))).collect(Collectors.toList());
        for (int i = 1; i < list2.size(); ++i) {
            if ((Long)list2.get(i) == (Long)list2.get(i - 1) + 1L) continue;
            throw new InvalidTableException(path.toString(), String.format("Missing delta files: versions are not contiguous: (%s)", list2));
        }
        if (list2.isEmpty() || !Objects.equals(list2.get(0), l)) {
            throw DeltaErrors.startVersionNotFound(path.toString(), l, list2.isEmpty() ? Optional.empty() : Optional.of((Long)list2.get(0)));
        }
        if (!Objects.equals(ListUtils.getLast(list2), l2)) {
            throw DeltaErrors.endVersionNotFound(path.toString(), l2, (Long)ListUtils.getLast(list2));
        }
    }

    private static CloseableIterator<FileStatus> listLogDir(Engine engine, Path path, long l) {
        Path path2 = new Path(path, "_delta_log");
        try {
            return DeltaErrors.wrapEngineExceptionThrowsIO(() -> engine.getFileSystemClient().listFrom(FileNames.listingPrefix(path2, l)), "Listing from %s", FileNames.listingPrefix(path2, l));
        }
        catch (FileNotFoundException fileNotFoundException) {
            throw new TableNotFoundException(path.toString());
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Failed to list the files in delta log", iOException);
        }
    }

    public static enum DeltaAction {
        REMOVE("remove", RemoveFile.FULL_SCHEMA),
        ADD("add", AddFile.FULL_SCHEMA),
        METADATA("metaData", Metadata.FULL_SCHEMA),
        PROTOCOL("protocol", Protocol.FULL_SCHEMA),
        COMMITINFO("commitInfo", CommitInfo.FULL_SCHEMA),
        CDC("cdc", AddCDCFile.FULL_SCHEMA);

        public final String colName;
        public final StructType schema;

        private DeltaAction(String string2, StructType structType) {
            this.colName = string2;
            this.schema = structType;
        }
    }
}

