/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal;

import io.delta.kernel.Operation;
import io.delta.kernel.Transaction;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.TableNotFoundException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.TableImpl;
import io.delta.kernel.internal.TransactionBuilderImpl;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;

public class ReplaceTableTransactionBuilderImpl
extends TransactionBuilderImpl {
    protected static final Set<String> TABLE_PROPERTY_KEYS_TO_PRESERVE = new HashSet<String>(){
        {
            this.add(TableConfig.COLUMN_MAPPING_MAX_COLUMN_ID.getKey());
        }
    };

    public ReplaceTableTransactionBuilderImpl(TableImpl tableImpl, String string) {
        super(tableImpl, string, Operation.REPLACE_TABLE);
    }

    @Override
    public Transaction build(Engine engine) {
        try {
            this.withMaxRetries(0);
            this.schema.orElseThrow(() -> DeltaErrors.requireSchemaForReplaceTable());
            SnapshotImpl snapshotImpl = (SnapshotImpl)this.table.getLatestSnapshot(engine);
            return this.buildTransactionInternal(engine, true, Optional.of(snapshotImpl));
        }
        catch (TableNotFoundException tableNotFoundException) {
            throw new TableNotFoundException(tableNotFoundException.getTablePath(), "Trying to replace a table that does not exist.");
        }
    }
}

