/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.InvalidTableException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CommitInfo {
    public static StructType FULL_SCHEMA = new StructType().add("inCommitTimestamp", (DataType)LongType.LONG, true).add("timestamp", LongType.LONG).add("engineInfo", StringType.STRING).add("operation", StringType.STRING).add("operationParameters", new MapType(StringType.STRING, StringType.STRING, true)).add("isBlindAppend", (DataType)BooleanType.BOOLEAN, true).add("txnId", StringType.STRING).add("operationMetrics", new MapType(StringType.STRING, StringType.STRING, true));
    private static final Map<String, Integer> COL_NAME_TO_ORDINAL = IntStream.range(0, FULL_SCHEMA.length()).boxed().collect(Collectors.toMap(n -> FULL_SCHEMA.at((int)n).getName(), n -> n));
    private static final Logger logger = LoggerFactory.getLogger(CommitInfo.class);
    private final long timestamp;
    private final String engineInfo;
    private final String operation;
    private final Map<String, String> operationParameters;
    private final boolean isBlindAppend;
    private final String txnId;
    private Optional<Long> inCommitTimestamp;
    private final Map<String, String> operationMetrics;

    public static CommitInfo fromColumnVector(ColumnVector columnVector, int n) {
        if (columnVector.isNullAt(n)) {
            return null;
        }
        ColumnVector[] columnVectorArray = new ColumnVector[8];
        for (int i = 0; i < columnVectorArray.length; ++i) {
            columnVectorArray[i] = columnVector.getChild(i);
        }
        return new CommitInfo(Optional.ofNullable(columnVectorArray[0].isNullAt(n) ? null : Long.valueOf(columnVectorArray[0].getLong(n))), columnVectorArray[1].isNullAt(n) ? null : Long.valueOf(columnVectorArray[1].getLong(n)), columnVectorArray[2].isNullAt(n) ? null : columnVectorArray[2].getString(n), columnVectorArray[3].isNullAt(n) ? null : columnVectorArray[3].getString(n), columnVectorArray[4].isNullAt(n) ? Collections.emptyMap() : VectorUtils.toJavaMap(columnVectorArray[4].getMap(n)), columnVectorArray[5].isNullAt(n) ? null : Boolean.valueOf(columnVectorArray[5].getBoolean(n)), columnVectorArray[6].isNullAt(n) ? null : columnVectorArray[6].getString(n), columnVectorArray[7].isNullAt(n) ? Collections.emptyMap() : VectorUtils.toJavaMap(columnVectorArray[7].getMap(n)));
    }

    public CommitInfo(Optional<Long> optional, long l, String string, String string2, Map<String, String> map, boolean bl, String string3, Map<String, String> map2) {
        this.inCommitTimestamp = Objects.requireNonNull(optional);
        this.timestamp = l;
        this.engineInfo = Objects.requireNonNull(string);
        this.operation = Objects.requireNonNull(string2);
        this.operationParameters = Collections.unmodifiableMap(Objects.requireNonNull(map));
        this.isBlindAppend = bl;
        this.txnId = Objects.requireNonNull(string3);
        this.operationMetrics = Collections.unmodifiableMap(Objects.requireNonNull(map2));
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getEngineInfo() {
        return this.engineInfo;
    }

    public String getOperation() {
        return this.operation;
    }

    public Map<String, String> getOperationParameters() {
        return this.operationParameters;
    }

    public boolean getIsBlindAppend() {
        return this.isBlindAppend;
    }

    public String getTxnId() {
        return this.txnId;
    }

    public Optional<Long> getInCommitTimestamp() {
        return this.inCommitTimestamp;
    }

    public Map<String, String> getOperationMetrics() {
        return this.operationMetrics;
    }

    public void setInCommitTimestamp(Optional<Long> optional) {
        this.inCommitTimestamp = optional;
    }

    public Row toRow() {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(COL_NAME_TO_ORDINAL.get("inCommitTimestamp"), this.inCommitTimestamp.orElse(null));
        hashMap.put(COL_NAME_TO_ORDINAL.get("timestamp"), this.timestamp);
        hashMap.put(COL_NAME_TO_ORDINAL.get("engineInfo"), this.engineInfo);
        hashMap.put(COL_NAME_TO_ORDINAL.get("operation"), this.operation);
        hashMap.put(COL_NAME_TO_ORDINAL.get("operationParameters"), VectorUtils.stringStringMapValue(this.operationParameters));
        hashMap.put(COL_NAME_TO_ORDINAL.get("isBlindAppend"), this.isBlindAppend);
        hashMap.put(COL_NAME_TO_ORDINAL.get("txnId"), this.txnId);
        hashMap.put(COL_NAME_TO_ORDINAL.get("operationMetrics"), VectorUtils.stringStringMapValue(this.operationMetrics));
        return new GenericRow(FULL_SCHEMA, hashMap);
    }

    public static long getRequiredInCommitTimestamp(Optional<CommitInfo> optional, String string, Path path) {
        CommitInfo commitInfo = optional.orElseThrow(() -> new InvalidTableException(path.toString(), String.format("This table has the feature inCommitTimestamp enabled which requires the presence of the CommitInfo action in every commit. However, the CommitInfo action is missing from commit version %s.", string)));
        return commitInfo.inCommitTimestamp.orElseThrow(() -> new InvalidTableException(path.toString(), String.format("This table has the feature inCommitTimestamp enabled which requires the presence of inCommitTimestamp in the CommitInfo action. However, this field has not been set in commit version %s.", string)));
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Optional<CommitInfo> getCommitInfoOpt(Engine engine, Path path, long l) {
        block14: {
            FileStatus fileStatus = FileStatus.of(FileNames.deltaFile(path, l), 0L, 0L);
            StructType structType = new StructType().add("commitInfo", FULL_SCHEMA);
            try {
                CloseableIterator closeableIterator = DeltaErrors.wrapEngineExceptionThrowsIO(() -> engine.getJsonHandler().readJsonFiles(Utils.singletonCloseableIterator(fileStatus), structType, Optional.empty()), "Reading the commit info with schema=%s from delta file %s", structType, fileStatus.getPath());
                block8: while (true) {
                    if (closeableIterator.hasNext()) {
                        ColumnarBatch columnarBatch = (ColumnarBatch)closeableIterator.next();
                        assert (columnarBatch.getSchema().equals(structType));
                        ColumnVector columnVector = columnarBatch.getColumnVector(0);
                        int n = 0;
                        while (true) {
                            CommitInfo commitInfo;
                            if (n >= columnVector.getSize()) continue block8;
                            if (!columnVector.isNullAt(n) && (commitInfo = CommitInfo.fromColumnVector(columnVector, n)) != null) {
                                Optional<CommitInfo> optional = Optional.of(commitInfo);
                                return optional;
                            }
                            ++n;
                        }
                    }
                    break block14;
                    break;
                }
                finally {
                    if (closeableIterator != null) {
                        closeableIterator.close();
                    }
                }
            }
            catch (IOException iOException) {
                throw new UncheckedIOException("Could not close iterator", iOException);
            }
        }
        logger.info("No commit info found for commit of version {}", (Object)l);
        return Optional.empty();
    }
}

