/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.expressions.Literal;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.RemoveFile;
import io.delta.kernel.internal.actions.SingleAction;
import io.delta.kernel.internal.annotation.VisibleForTesting;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.internal.data.TransactionStateRow;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.icebergcompat.IcebergCompatV2MetadataValidatorAndUpdater;
import io.delta.kernel.internal.util.InternalUtils;
import io.delta.kernel.internal.util.PartitionUtils;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.statistics.DataFileStatistics;
import io.delta.kernel.types.StructType;
import io.delta.kernel.utils.DataFileStatus;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;

public final class GenerateIcebergCompatActionUtils {
    public static Row generateIcebergCompatWriterV1AddAction(Row row, DataFileStatus dataFileStatus, Map<String, Literal> map, boolean bl, Map<String, String> map2) {
        Map<String, String> map3 = TransactionStateRow.getConfiguration(row);
        GenerateIcebergCompatActionUtils.validateIcebergWriterCompatV1Enabled(map3);
        GenerateIcebergCompatActionUtils.validateMaxRetriesSetToZero(row);
        Preconditions.checkState(TableConfig.ICEBERG_COMPAT_V2_ENABLED.fromMetadata(map3), "icebergCompatV2 not enabled despite icebergWriterCompatV1 enabled");
        IcebergCompatV2MetadataValidatorAndUpdater.validateDataFileStatus(dataFileStatus);
        GenerateIcebergCompatActionUtils.blockPartitionedTables(row, map);
        URI uRI = new Path(TransactionStateRow.getTablePath(row)).toUri();
        AddFile addFile = AddFile.convertDataFileStatus(TransactionStateRow.getPhysicalSchema(row), uRI, dataFileStatus, map, bl, map2);
        return SingleAction.createAddFileSingleAction(addFile.toRow());
    }

    public static Row generateIcebergCompatWriterV1AddAction(Row row, DataFileStatus dataFileStatus, Map<String, Literal> map, boolean bl) {
        return GenerateIcebergCompatActionUtils.generateIcebergCompatWriterV1AddAction(row, dataFileStatus, map, bl, Collections.emptyMap());
    }

    public static Row generateIcebergCompatWriterV1RemoveAction(Row row, DataFileStatus dataFileStatus, Map<String, Literal> map, boolean bl) {
        Map<String, String> map2 = TransactionStateRow.getConfiguration(row);
        GenerateIcebergCompatActionUtils.validateIcebergWriterCompatV1Enabled(map2);
        GenerateIcebergCompatActionUtils.validateMaxRetriesSetToZero(row);
        if (bl && TableConfig.APPEND_ONLY_ENABLED.fromMetadata(map2).booleanValue()) {
            throw DeltaErrors.cannotModifyAppendOnlyTable(TransactionStateRow.getTablePath(row));
        }
        GenerateIcebergCompatActionUtils.blockPartitionedTables(row, map);
        URI uRI = new Path(TransactionStateRow.getTablePath(row)).toUri();
        Row row2 = GenerateIcebergCompatActionUtils.convertRemoveDataFileStatus(TransactionStateRow.getPhysicalSchema(row), uRI, dataFileStatus, map, bl);
        return SingleAction.createRemoveFileSingleAction(row2);
    }

    private static void validateIcebergWriterCompatV1Enabled(Map<String, String> map) {
        if (!TableConfig.ICEBERG_WRITER_COMPAT_V1_ENABLED.fromMetadata(map).booleanValue()) {
            throw new UnsupportedOperationException(String.format("APIs within GenerateIcebergCompatActionUtils are only supported on tables with '%s' set to true", TableConfig.ICEBERG_WRITER_COMPAT_V1_ENABLED.getKey()));
        }
    }

    private static void validateMaxRetriesSetToZero(Row row) {
        if (TransactionStateRow.getMaxRetries(row) > 0) {
            throw new UnsupportedOperationException(String.format("Usage of GenerateIcebergCompatActionUtils requires maxRetries=0, found maxRetries=%s", TransactionStateRow.getMaxRetries(row)));
        }
    }

    private static void blockPartitionedTables(Row row, Map<String, Literal> map) {
        if (!TransactionStateRow.getPartitionColumnsList(row).isEmpty()) {
            throw new UnsupportedOperationException("Currently GenerateIcebergCompatActionUtils is not supported for partitioned tables");
        }
        Preconditions.checkArgument(map.isEmpty(), "Non-empty partitionValues provided for an unpartitioned table");
    }

    @VisibleForTesting
    public static Row convertRemoveDataFileStatus(StructType structType, URI uRI, DataFileStatus dataFileStatus, Map<String, Literal> map, boolean bl) {
        return GenerateIcebergCompatActionUtils.createRemoveFileRowWithExtendedFileMetadata(InternalUtils.relativizePath(new Path(dataFileStatus.getPath()), uRI).toUri().toString(), dataFileStatus.getModificationTime(), bl, PartitionUtils.serializePartitionMap(map), dataFileStatus.getSize(), dataFileStatus.getStatistics(), structType);
    }

    @VisibleForTesting
    public static Row createRemoveFileRowWithExtendedFileMetadata(String string, long l, boolean bl, MapValue mapValue, long l2, Optional<DataFileStatistics> optional, StructType structType) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("path"), Objects.requireNonNull(string));
        hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("deletionTimestamp"), l);
        hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("dataChange"), bl);
        hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("extendedFileMetadata"), true);
        hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("partitionValues"), Objects.requireNonNull(mapValue));
        hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("size"), l2);
        optional.ifPresent(dataFileStatistics -> hashMap.put(RemoveFile.FULL_SCHEMA.indexOf("stats"), dataFileStatistics.serializeAsJson(structType)));
        return new GenericRow(RemoveFile.FULL_SCHEMA, hashMap);
    }
}

