/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.internal.tablefeatures.TableFeature;
import io.delta.kernel.internal.tablefeatures.TableFeatures;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.internal.util.Tuple2;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class Protocol {
    public static final StructType FULL_SCHEMA = new StructType().add("minReaderVersion", (DataType)IntegerType.INTEGER, false).add("minWriterVersion", (DataType)IntegerType.INTEGER, false).add("readerFeatures", new ArrayType(StringType.STRING, false)).add("writerFeatures", new ArrayType(StringType.STRING, false));
    private final int minReaderVersion;
    private final int minWriterVersion;
    private final Set<String> readerFeatures;
    private final Set<String> writerFeatures;
    private final boolean supportsReaderFeatures;
    private final boolean supportsWriterFeatures;

    public static Protocol fromRow(Row row) {
        Objects.requireNonNull(row);
        Set<String> set = row.isNullAt(2) ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet(VectorUtils.toJavaList(row.getArray(2))));
        Set<String> set2 = row.isNullAt(3) ? Collections.emptySet() : Collections.unmodifiableSet(new HashSet(VectorUtils.toJavaList(row.getArray(3))));
        return new Protocol(row.getInt(0), row.getInt(1), set, set2);
    }

    public static Protocol fromColumnVector(ColumnVector columnVector, int n) {
        if (columnVector.isNullAt(n)) {
            return null;
        }
        return new Protocol(columnVector.getChild(0).getInt(n), columnVector.getChild(1).getInt(n), columnVector.getChild(2).isNullAt(n) ? Collections.emptySet() : new HashSet<String>(VectorUtils.toJavaList(columnVector.getChild(2).getArray(n))), columnVector.getChild(3).isNullAt(n) ? Collections.emptySet() : new HashSet(VectorUtils.toJavaList(columnVector.getChild(3).getArray(n))));
    }

    public Protocol(int n, int n2) {
        this(n, n2, Collections.emptySet(), Collections.emptySet());
    }

    public Protocol(int n, int n2, Set<String> set, Set<String> set2) {
        this.minReaderVersion = n;
        this.minWriterVersion = n2;
        this.readerFeatures = Collections.unmodifiableSet(Objects.requireNonNull(set, "readerFeatures cannot be null"));
        this.writerFeatures = Collections.unmodifiableSet(Objects.requireNonNull(set2, "writerFeatures cannot be null"));
        this.supportsReaderFeatures = TableFeatures.supportsReaderFeatures(n);
        this.supportsWriterFeatures = TableFeatures.supportsWriterFeatures(n2);
    }

    public int getMinReaderVersion() {
        return this.minReaderVersion;
    }

    public int getMinWriterVersion() {
        return this.minWriterVersion;
    }

    public Set<String> getReaderFeatures() {
        return this.readerFeatures;
    }

    public Set<String> getWriterFeatures() {
        return this.writerFeatures;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("Protocol{");
        stringBuilder.append("minReaderVersion=").append(this.minReaderVersion);
        stringBuilder.append(", minWriterVersion=").append(this.minWriterVersion);
        stringBuilder.append(", readerFeatures=").append(this.readerFeatures);
        stringBuilder.append(", writerFeatures=").append(this.writerFeatures);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        Protocol protocol = (Protocol)object;
        return this.minReaderVersion == protocol.minReaderVersion && this.minWriterVersion == protocol.minWriterVersion && Objects.equals(this.readerFeatures, protocol.readerFeatures) && Objects.equals(this.writerFeatures, protocol.writerFeatures);
    }

    public int hashCode() {
        return Objects.hash(this.minReaderVersion, this.minWriterVersion, this.readerFeatures, this.writerFeatures);
    }

    public Row toRow() {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(0, this.minReaderVersion);
        hashMap.put(1, this.minWriterVersion);
        if (this.supportsReaderFeatures) {
            hashMap.put(2, VectorUtils.buildArrayValue(new ArrayList<String>(this.readerFeatures), StringType.STRING));
        }
        if (this.supportsWriterFeatures) {
            hashMap.put(3, VectorUtils.buildArrayValue(new ArrayList<String>(this.writerFeatures), StringType.STRING));
        }
        return new GenericRow(FULL_SCHEMA, hashMap);
    }

    public Set<TableFeature> getImplicitlySupportedFeatures() {
        if (this.supportsReaderFeatures && this.supportsWriterFeatures) {
            return Collections.emptySet();
        }
        return TableFeatures.TABLE_FEATURES.stream().filter(tableFeature -> !this.supportsReaderFeatures && tableFeature.minReaderVersion() <= this.minReaderVersion).filter(tableFeature -> !this.supportsWriterFeatures && tableFeature.minWriterVersion() <= this.minWriterVersion).collect(Collectors.toSet());
    }

    public Set<TableFeature> getExplicitlySupportedFeatures() {
        return Stream.of(this.readerFeatures, this.writerFeatures).flatMap(Collection::stream).map(TableFeatures::getTableFeature).collect(Collectors.toSet());
    }

    public Set<TableFeature> getImplicitlyAndExplicitlySupportedFeatures() {
        HashSet<TableFeature> hashSet = new HashSet<TableFeature>();
        hashSet.addAll(this.getImplicitlySupportedFeatures());
        hashSet.addAll(this.getExplicitlySupportedFeatures());
        return hashSet;
    }

    public Set<TableFeature> getImplicitlyAndExplicitlySupportedReaderWriterFeatures() {
        return Stream.concat(TableFeatures.TABLE_FEATURES.stream().filter(tableFeature -> !this.supportsReaderFeatures && tableFeature.minReaderVersion() <= this.getMinReaderVersion()), this.readerFeatures.stream().map(TableFeatures::getTableFeature)).collect(Collectors.toSet());
    }

    public Protocol withFeatures(Iterable<TableFeature> iterable) {
        Protocol protocol = this;
        for (TableFeature tableFeature : iterable) {
            protocol = protocol.withFeature(tableFeature);
        }
        return protocol;
    }

    public Protocol withFeature(TableFeature tableFeature) {
        Protocol protocol = this.withFeatures(tableFeature.requiredFeatures());
        if (tableFeature.minReaderVersion() > protocol.minReaderVersion) {
            throw new UnsupportedOperationException("TableFeature requires higher reader protocol version");
        }
        if (tableFeature.minWriterVersion() > protocol.minWriterVersion) {
            throw new UnsupportedOperationException("TableFeature requires higher writer protocol version");
        }
        boolean bl = tableFeature.isReaderWriterFeature() && this.supportsReaderFeatures;
        Set<String> set = protocol.readerFeatures;
        Set<String> set2 = protocol.writerFeatures;
        if (bl) {
            set = new HashSet<String>(protocol.readerFeatures);
            set.add(tableFeature.featureName());
        }
        if (this.supportsWriterFeatures) {
            set2 = new HashSet<String>(protocol.writerFeatures);
            set2.add(tableFeature.featureName());
        }
        return new Protocol(protocol.minReaderVersion, protocol.minWriterVersion, set, set2);
    }

    public boolean canUpgradeTo(Protocol protocol) {
        return protocol.getImplicitlyAndExplicitlySupportedFeatures().containsAll(this.getImplicitlyAndExplicitlySupportedFeatures());
    }

    public Protocol normalized() {
        if (!this.isFeatureProtocol()) {
            return this;
        }
        Tuple2<Integer, Integer> tuple2 = TableFeatures.minimumRequiredVersions(this.getExplicitlySupportedFeatures());
        int n = (Integer)tuple2._1;
        int n2 = (Integer)tuple2._2;
        Protocol protocol = new Protocol(n, n2);
        if (this.getImplicitlyAndExplicitlySupportedFeatures().equals(protocol.getImplicitlyAndExplicitlySupportedFeatures())) {
            return protocol;
        }
        return new Protocol(n, 7).withFeatures(this.getExplicitlySupportedFeatures());
    }

    public Protocol denormalized() {
        if (!this.isLegacyProtocol()) {
            return this;
        }
        Tuple2<Integer, Integer> tuple2 = TableFeatures.minimumRequiredVersions(this.getImplicitlySupportedFeatures());
        int n = (Integer)tuple2._1;
        return new Protocol(n, 7).withFeatures(this.getImplicitlySupportedFeatures());
    }

    public Protocol denormalizedNormalized() {
        return this.denormalized().normalized();
    }

    public Protocol merge(Protocol ... protocolArray) {
        ArrayList<Protocol> arrayList = new ArrayList<Protocol>();
        arrayList.add(this);
        arrayList.addAll(Arrays.asList(protocolArray));
        int n = arrayList.stream().mapToInt(Protocol::getMinReaderVersion).max().orElse(0);
        int n2 = arrayList.stream().mapToInt(Protocol::getMinWriterVersion).max().orElse(0);
        Set<String> set = arrayList.stream().flatMap(protocol -> protocol.readerFeatures.stream()).collect(Collectors.toSet());
        Set<String> set2 = arrayList.stream().flatMap(protocol -> protocol.writerFeatures.stream()).collect(Collectors.toSet());
        Set<TableFeature> set3 = arrayList.stream().flatMap(protocol -> protocol.getImplicitlySupportedFeatures().stream()).collect(Collectors.toSet());
        Protocol protocol2 = new Protocol(n, n2, set, set2).withFeatures(set3);
        return protocol2.denormalizedNormalized();
    }

    public boolean supportsFeature(TableFeature tableFeature) {
        return this.getImplicitlyAndExplicitlySupportedFeatures().contains(tableFeature);
    }

    protected void validate() {
        Preconditions.checkArgument(this.minReaderVersion >= 1, "minReaderVersion should be at least 1");
        Preconditions.checkArgument(this.minWriterVersion >= 1, "minWriterVersion should be at least 1");
        Preconditions.checkArgument(this.readerFeatures.isEmpty() || this.supportsReaderFeatures, "Reader features are not supported for the reader version: " + this.minReaderVersion);
        Preconditions.checkArgument(this.writerFeatures.isEmpty() || this.supportsWriterFeatures, "Writer features are not supported for the writer version: " + this.minWriterVersion);
        if (this.supportsReaderFeatures) {
            Preconditions.checkArgument(this.supportsWriterFeatures, "writer version doesn't support writer features: " + this.minWriterVersion);
        }
        if (this.supportsWriterFeatures) {
            Set<TableFeature> set = this.getExplicitlySupportedFeatures();
            set.stream().filter(TableFeature::isReaderWriterFeature).forEach(tableFeature -> {
                Preconditions.checkArgument(tableFeature.minReaderVersion() <= this.minReaderVersion, String.format("Reader version %d does not support readerWriter feature %s", this.minReaderVersion, tableFeature.featureName()));
                if (this.supportsReaderFeatures) {
                    Preconditions.checkArgument(this.readerFeatures.contains(tableFeature.featureName()), String.format("ReaderWriter feature %s is not present in readerFeatures", tableFeature.featureName()));
                }
            });
        } else {
            TableFeatures.TABLE_FEATURES.stream().filter(TableFeature::isReaderWriterFeature).forEach(tableFeature -> {
                if (tableFeature.minWriterVersion() <= this.minWriterVersion) {
                    Preconditions.checkArgument(tableFeature.minReaderVersion() <= this.minReaderVersion, String.format("Reader version %d does not support readerWriter feature %s", this.minReaderVersion, tableFeature.featureName()));
                }
            });
        }
    }

    private boolean isLegacyProtocol() {
        return !this.supportsReaderFeatures && !this.supportsWriterFeatures;
    }

    private boolean isFeatureProtocol() {
        return this.supportsWriterFeatures;
    }
}

