/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.actions.DeletionVectorDescriptor;
import io.delta.kernel.internal.actions.RowBackedAction;
import io.delta.kernel.internal.util.StatsUtils;
import io.delta.kernel.internal.util.VectorUtils;
import io.delta.kernel.statistics.DataFileStatistics;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.util.Optional;

public class RemoveFile
extends RowBackedAction {
    public static final StructType FULL_SCHEMA = new StructType().add("path", (DataType)StringType.STRING, false).add("deletionTimestamp", (DataType)LongType.LONG, true).add("dataChange", (DataType)BooleanType.BOOLEAN, false).add("extendedFileMetadata", (DataType)BooleanType.BOOLEAN, true).add("partitionValues", (DataType)new MapType(StringType.STRING, StringType.STRING, true), true).add("size", (DataType)LongType.LONG, true).add("stats", (DataType)StringType.STRING, true).add("tags", (DataType)new MapType(StringType.STRING, StringType.STRING, true), true).add("deletionVector", (DataType)DeletionVectorDescriptor.READ_SCHEMA, true).add("baseRowId", (DataType)LongType.LONG, true).add("defaultRowCommitVersion", (DataType)LongType.LONG, true);

    public RemoveFile(Row row) {
        super(row);
    }

    public String getPath() {
        return this.row.getString(this.getFieldIndex("path"));
    }

    public Optional<Long> getDeletionTimestamp() {
        return this.row.isNullAt(this.getFieldIndex("deletionTimestamp")) ? Optional.empty() : Optional.of(this.row.getLong(this.getFieldIndex("deletionTimestamp")));
    }

    public boolean getDataChange() {
        return this.row.getBoolean(this.getFieldIndex("dataChange"));
    }

    public Optional<Boolean> getExtendedFileMetadata() {
        return this.row.isNullAt(this.getFieldIndex("extendedFileMetadata")) ? Optional.empty() : Optional.of(this.row.getBoolean(this.getFieldIndex("extendedFileMetadata")));
    }

    public Optional<MapValue> getPartitionValues() {
        return this.row.isNullAt(this.getFieldIndex("partitionValues")) ? Optional.empty() : Optional.of(this.row.getMap(this.getFieldIndex("partitionValues")));
    }

    public Optional<Long> getSize() {
        return this.row.isNullAt(this.getFieldIndex("size")) ? Optional.empty() : Optional.of(this.row.getLong(this.getFieldIndex("size")));
    }

    public Optional<String> getStatsJson() {
        return this.getFieldIndexOpt("stats").flatMap(n -> this.row.isNullAt((int)n) ? Optional.empty() : Optional.of(this.row.getString((int)n)));
    }

    public Optional<DataFileStatistics> getStats() {
        return this.getStatsJson().flatMap(StatsUtils::deserializeFromJson);
    }

    public Optional<MapValue> getTags() {
        int n = this.getFieldIndex("tags");
        return Optional.ofNullable(this.row.isNullAt(n) ? null : this.row.getMap(n));
    }

    public Optional<DeletionVectorDescriptor> getDeletionVector() {
        int n = this.getFieldIndex("deletionVector");
        return Optional.ofNullable(this.row.isNullAt(n) ? null : DeletionVectorDescriptor.fromRow(this.row.getStruct(n)));
    }

    public Optional<Long> getBaseRowId() {
        int n = this.getFieldIndex("baseRowId");
        return Optional.ofNullable(this.row.isNullAt(n) ? null : Long.valueOf(this.row.getLong(n)));
    }

    public Optional<Long> getDefaultRowCommitVersion() {
        int n = this.getFieldIndex("defaultRowCommitVersion");
        return Optional.ofNullable(this.row.isNullAt(n) ? null : Long.valueOf(this.row.getLong(n)));
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("RemoveFile{");
        stringBuilder.append("path='").append(this.getPath()).append('\'');
        stringBuilder.append(", deletionTimestamp=").append(this.getDeletionTimestamp());
        stringBuilder.append(", dataChange=").append(this.getDataChange());
        stringBuilder.append(", extendedFileMetadata=").append(this.getExtendedFileMetadata());
        stringBuilder.append(", partitionValues=").append(this.getPartitionValues().map(VectorUtils::toJavaMap));
        stringBuilder.append(", size=").append(this.getSize());
        stringBuilder.append(", stats=").append(this.getStats().map(dataFileStatistics -> dataFileStatistics.serializeAsJson(null)).orElse(""));
        stringBuilder.append(", tags=").append(this.getTags().map(VectorUtils::toJavaMap));
        stringBuilder.append(", deletionVector=").append(this.getDeletionVector());
        stringBuilder.append(", baseRowId=").append(this.getBaseRowId());
        stringBuilder.append(", defaultRowCommitVersion=").append(this.getDefaultRowCommitVersion());
        stringBuilder.append('}');
        return stringBuilder.toString();
    }
}

