/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.Row;
import io.delta.kernel.internal.data.DelegateRow;
import io.delta.kernel.internal.util.Preconditions;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;

public abstract class RowBackedAction {
    protected final Row row;

    protected RowBackedAction(Row row) {
        this.row = row;
    }

    protected int getFieldIndex(String string) {
        int n = this.row.getSchema().indexOf(string);
        Preconditions.checkArgument(n >= 0, "Field '%s' not found in schema: %s", string, this.row.getSchema());
        return n;
    }

    protected Optional<Integer> getFieldIndexOpt(String string) {
        int n = this.row.getSchema().indexOf(string);
        return n >= 0 ? Optional.of(n) : Optional.empty();
    }

    protected Row toRowWithOverriddenValue(String string, Object object) {
        Map<Integer, Object> map = Collections.singletonMap(this.getFieldIndex(string), object);
        return new DelegateRow(this.row, map);
    }

    public final Row toRow() {
        return this.row;
    }
}

