/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.actions;

import io.delta.kernel.data.Row;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.CommitInfo;
import io.delta.kernel.internal.actions.DomainMetadata;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.actions.RemoveFile;
import io.delta.kernel.internal.actions.SetTransaction;
import io.delta.kernel.internal.data.GenericRow;
import io.delta.kernel.types.StructType;
import java.util.Collections;
import java.util.HashMap;

public class SingleAction {
    public static StructType CHECKPOINT_SCHEMA = new StructType().add("txn", SetTransaction.FULL_SCHEMA).add("add", AddFile.FULL_SCHEMA).add("remove", RemoveFile.FULL_SCHEMA).add("metaData", Metadata.FULL_SCHEMA).add("protocol", Protocol.FULL_SCHEMA).add("domainMetadata", DomainMetadata.FULL_SCHEMA);
    public static StructType CONFLICT_RESOLUTION_SCHEMA = new StructType().add("txn", SetTransaction.FULL_SCHEMA).add("metaData", Metadata.FULL_SCHEMA).add("protocol", Protocol.FULL_SCHEMA).add("commitInfo", CommitInfo.FULL_SCHEMA).add("domainMetadata", DomainMetadata.FULL_SCHEMA);
    public static StructType FULL_SCHEMA = new StructType().add("txn", SetTransaction.FULL_SCHEMA).add("add", AddFile.FULL_SCHEMA).add("remove", RemoveFile.FULL_SCHEMA).add("metaData", Metadata.FULL_SCHEMA).add("protocol", Protocol.FULL_SCHEMA).add("cdc", new StructType()).add("commitInfo", CommitInfo.FULL_SCHEMA).add("domainMetadata", DomainMetadata.FULL_SCHEMA);
    private static final int TXN_ORDINAL = FULL_SCHEMA.indexOf("txn");
    public static final int ADD_FILE_ORDINAL = FULL_SCHEMA.indexOf("add");
    public static final int REMOVE_FILE_ORDINAL = FULL_SCHEMA.indexOf("remove");
    private static final int METADATA_ORDINAL = FULL_SCHEMA.indexOf("metaData");
    private static final int PROTOCOL_ORDINAL = FULL_SCHEMA.indexOf("protocol");
    private static final int COMMIT_INFO_ORDINAL = FULL_SCHEMA.indexOf("commitInfo");
    private static final int DOMAIN_METADATA_ORDINAL = FULL_SCHEMA.indexOf("domainMetadata");

    public static Row createAddFileSingleAction(Row row) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(ADD_FILE_ORDINAL, row);
        return new GenericRow(FULL_SCHEMA, hashMap);
    }

    public static Row createProtocolSingleAction(Row row) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(PROTOCOL_ORDINAL, row);
        return new GenericRow(FULL_SCHEMA, hashMap);
    }

    public static Row createMetadataSingleAction(Row row) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(METADATA_ORDINAL, row);
        return new GenericRow(FULL_SCHEMA, hashMap);
    }

    public static Row createRemoveFileSingleAction(Row row) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(REMOVE_FILE_ORDINAL, row);
        return new GenericRow(FULL_SCHEMA, hashMap);
    }

    public static Row createCommitInfoSingleAction(Row row) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(COMMIT_INFO_ORDINAL, row);
        return new GenericRow(FULL_SCHEMA, hashMap);
    }

    public static Row createDomainMetadataSingleAction(Row row) {
        return new GenericRow(FULL_SCHEMA, Collections.singletonMap(DOMAIN_METADATA_ORDINAL, row));
    }

    public static Row createTxnSingleAction(Row row) {
        HashMap<Integer, Object> hashMap = new HashMap<Integer, Object>();
        hashMap.put(TXN_ORDINAL, row);
        return new GenericRow(FULL_SCHEMA, hashMap);
    }
}

