/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.checksum;

import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.internal.checksum.CRCInfo;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ChecksumReader {
    private static final Logger logger = LoggerFactory.getLogger(ChecksumReader.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<CRCInfo> getCRCInfo(Engine engine, FileStatus fileStatus) {
        try (CloseableIterator<ColumnarBatch> closeableIterator = engine.getJsonHandler().readJsonFiles(Utils.singletonCloseableIterator(fileStatus), CRCInfo.CRC_FILE_SCHEMA, Optional.empty());){
            if (!closeableIterator.hasNext()) {
                logger.warn("Checksum file is empty: {}", (Object)fileStatus.getPath());
                Optional<CRCInfo> optional = Optional.empty();
                return optional;
            }
            ColumnarBatch columnarBatch = closeableIterator.next();
            if (columnarBatch.getSize() != 1) {
                String string = "Expected exactly one row in the checksum file {}, found {} rows";
                logger.warn(string, (Object)fileStatus.getPath(), (Object)columnarBatch.getSize());
                Optional<CRCInfo> optional = Optional.empty();
                return optional;
            }
            long l = FileNames.checksumVersion(new Path(fileStatus.getPath()));
            Optional<CRCInfo> optional = CRCInfo.fromColumnarBatch(l, columnarBatch, 0, fileStatus.getPath());
            return optional;
        }
        catch (Exception exception) {
            logger.warn("Failed to read checksum file {}", (Object)fileStatus.getPath(), (Object)exception);
            return Optional.empty();
        }
    }
}

