/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.compaction;

import io.delta.kernel.data.Row;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.DeltaLogActionUtils;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.lang.ListUtils;
import io.delta.kernel.internal.replay.CreateCheckpointIterator;
import io.delta.kernel.internal.snapshot.LogSegment;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Utils;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.IOException;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LogCompactionWriter {
    private static final Logger logger = LoggerFactory.getLogger(LogCompactionWriter.class);
    private final Path dataPath;
    private final Path logPath;
    private final long startVersion;
    private final long endVersion;
    private final long minFileRetentionTimestampMillis;

    public LogCompactionWriter(Path path, Path path2, long l, long l2, long l3) {
        this.dataPath = Objects.requireNonNull(path);
        this.logPath = Objects.requireNonNull(path2);
        this.startVersion = l;
        this.endVersion = l2;
        this.minFileRetentionTimestampMillis = l3;
    }

    public void writeLogCompactionFile(Engine engine) throws IOException {
        Path path = FileNames.logCompactionPath(this.logPath, this.startVersion, this.endVersion);
        logger.info("Writing log compaction file for versions {} to {} to path: {}", new Object[]{this.startVersion, this.endVersion, path});
        long l = System.currentTimeMillis();
        List<FileStatus> list = DeltaLogActionUtils.listDeltaLogFilesAsIter(engine, Collections.singleton(FileNames.DeltaLogFileType.COMMIT), this.dataPath, this.startVersion, Optional.of(this.endVersion), false).toInMemoryList();
        logger.info("{}: Took {}ms to list commit files for log compaction", (Object)this.dataPath, (Object)(System.currentTimeMillis() - l));
        if ((long)list.size() != this.endVersion - this.startVersion + 1L) {
            throw new IllegalArgumentException(String.format("Asked to compact between versions %d and %d, but found %d delta files", this.startVersion, this.endVersion, list.size()));
        }
        long l2 = ListUtils.getLast(list).getModificationTime();
        LogSegment logSegment = new LogSegment(this.dataPath, this.endVersion, list, Collections.emptyList(), Collections.emptyList(), Optional.empty(), l2);
        CreateCheckpointIterator createCheckpointIterator = new CreateCheckpointIterator(engine, logSegment, this.minFileRetentionTimestampMillis);
        DeltaErrors.wrapEngineExceptionThrowsIO(() -> {
            try (CloseableIterator<Row> closeableIterator = Utils.intoRows(createCheckpointIterator);){
                engine.getJsonHandler().writeJsonFileAtomically(path.toString(), closeableIterator, false);
            }
            logger.info("Successfully wrote log compaction file `{}`", (Object)path);
            return null;
        }, "Writing log compaction file `%s`", path);
    }

    public static boolean shouldCompact(long l, long l2) {
        return l > 0L && (l + 1L) % l2 == 0L;
    }
}

