/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.data;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class DelegateRow
implements Row {
    private final Row row;
    private final Map<Integer, Object> overrides;

    public DelegateRow(Row row, Map<Integer, Object> map) {
        Objects.requireNonNull(row, "row is null");
        Objects.requireNonNull(map, "map of overrides is null");
        if (row instanceof DelegateRow) {
            DelegateRow delegateRow = (DelegateRow)row;
            this.row = delegateRow.row;
            this.overrides = new HashMap<Integer, Object>(delegateRow.overrides);
            this.overrides.putAll(map);
        } else {
            this.row = row;
            this.overrides = new HashMap<Integer, Object>(map);
        }
    }

    @Override
    public StructType getSchema() {
        return this.row.getSchema();
    }

    @Override
    public boolean isNullAt(int n) {
        if (this.overrides.containsKey(n)) {
            return this.overrides.get(n) == null;
        }
        return this.row.isNullAt(n);
    }

    @Override
    public boolean getBoolean(int n) {
        if (this.overrides.containsKey(n)) {
            this.throwIfUnsafeAccess(n, BooleanType.class, "boolean");
            return (Boolean)this.overrides.get(n);
        }
        return this.row.getBoolean(n);
    }

    @Override
    public byte getByte(int n) {
        if (this.overrides.containsKey(n)) {
            this.throwIfUnsafeAccess(n, ByteType.class, "byte");
            return (Byte)this.overrides.get(n);
        }
        return this.row.getByte(n);
    }

    @Override
    public short getShort(int n) {
        this.throwIfUnsafeAccess(n, ShortType.class, "short");
        if (this.overrides.containsKey(n)) {
            return (Short)this.overrides.get(n);
        }
        return this.row.getShort(n);
    }

    @Override
    public int getInt(int n) {
        if (this.overrides.containsKey(n)) {
            this.throwIfUnsafeAccess(n, IntegerType.class, "integer");
            return (Integer)this.overrides.get(n);
        }
        return this.row.getInt(n);
    }

    @Override
    public long getLong(int n) {
        if (this.overrides.containsKey(n)) {
            this.throwIfUnsafeAccess(n, LongType.class, "long");
            return (Long)this.overrides.get(n);
        }
        return this.row.getLong(n);
    }

    @Override
    public float getFloat(int n) {
        if (this.overrides.containsKey(n)) {
            this.throwIfUnsafeAccess(n, FloatType.class, "float");
            return ((Float)this.overrides.get(n)).floatValue();
        }
        return this.row.getFloat(n);
    }

    @Override
    public double getDouble(int n) {
        if (this.overrides.containsKey(n)) {
            this.throwIfUnsafeAccess(n, DoubleType.class, "double");
            return (Double)this.overrides.get(n);
        }
        return this.row.getDouble(n);
    }

    @Override
    public String getString(int n) {
        if (this.overrides.containsKey(n)) {
            this.throwIfUnsafeAccess(n, StringType.class, "string");
            return (String)this.overrides.get(n);
        }
        return this.row.getString(n);
    }

    @Override
    public BigDecimal getDecimal(int n) {
        if (this.overrides.containsKey(n)) {
            this.throwIfUnsafeAccess(n, DecimalType.class, "decimal");
            return (BigDecimal)this.overrides.get(n);
        }
        return this.row.getDecimal(n);
    }

    @Override
    public byte[] getBinary(int n) {
        if (this.overrides.containsKey(n)) {
            this.throwIfUnsafeAccess(n, BinaryType.class, "binary");
            return (byte[])this.overrides.get(n);
        }
        return this.row.getBinary(n);
    }

    @Override
    public Row getStruct(int n) {
        if (this.overrides.containsKey(n)) {
            this.throwIfUnsafeAccess(n, StructType.class, "struct");
            return (Row)this.overrides.get(n);
        }
        return this.row.getStruct(n);
    }

    @Override
    public ArrayValue getArray(int n) {
        if (this.overrides.containsKey(n)) {
            this.throwIfUnsafeAccess(n, ArrayType.class, "array");
            return (ArrayValue)this.overrides.get(n);
        }
        return this.row.getArray(n);
    }

    @Override
    public MapValue getMap(int n) {
        if (this.overrides.containsKey(n)) {
            this.throwIfUnsafeAccess(n, MapType.class, "map");
            return (MapValue)this.overrides.get(n);
        }
        return this.row.getMap(n);
    }

    private void throwIfUnsafeAccess(int n, Class<? extends DataType> clazz, String string) {
        StructType structType = this.row.getSchema();
        Preconditions.checkArgument(n >= 0 && n < structType.length(), "Invalid ordinal %d for schema with length %d", n, structType.length());
        DataType dataType = structType.at(n).getDataType();
        if (!clazz.isAssignableFrom(dataType.getClass())) {
            String string2 = String.format("Fail to access a '%s' value from a field of type '%s'", string, dataType);
            throw new UnsupportedOperationException(string2);
        }
    }
}

