/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.data;

import io.delta.kernel.data.ArrayValue;
import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.MapValue;
import io.delta.kernel.data.Row;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.types.ArrayType;
import io.delta.kernel.types.BinaryType;
import io.delta.kernel.types.BooleanType;
import io.delta.kernel.types.ByteType;
import io.delta.kernel.types.DataType;
import io.delta.kernel.types.DateType;
import io.delta.kernel.types.DecimalType;
import io.delta.kernel.types.DoubleType;
import io.delta.kernel.types.FloatType;
import io.delta.kernel.types.IntegerType;
import io.delta.kernel.types.LongType;
import io.delta.kernel.types.MapType;
import io.delta.kernel.types.ShortType;
import io.delta.kernel.types.StringType;
import io.delta.kernel.types.StructType;
import io.delta.kernel.types.TimestampNTZType;
import io.delta.kernel.types.TimestampType;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;

public class GenericColumnVector
implements ColumnVector {
    private final List<?> values;
    private final DataType dataType;

    public GenericColumnVector(List<?> list, DataType dataType) {
        this.values = list;
        this.dataType = dataType;
    }

    @Override
    public DataType getDataType() {
        return this.dataType;
    }

    @Override
    public int getSize() {
        return this.values.size();
    }

    @Override
    public void close() {
    }

    @Override
    public boolean isNullAt(int n) {
        this.validateRowId(n);
        return this.values.get(n) == null;
    }

    @Override
    public boolean getBoolean(int n) {
        Preconditions.checkArgument(BooleanType.BOOLEAN.equals(this.dataType));
        return (Boolean)this.getValidatedValue(n, Boolean.class);
    }

    @Override
    public byte getByte(int n) {
        Preconditions.checkArgument(ByteType.BYTE.equals(this.dataType));
        return (Byte)this.getValidatedValue(n, Byte.class);
    }

    @Override
    public short getShort(int n) {
        Preconditions.checkArgument(ShortType.SHORT.equals(this.dataType));
        return (Short)this.getValidatedValue(n, Short.class);
    }

    @Override
    public int getInt(int n) {
        Preconditions.checkArgument(IntegerType.INTEGER.equals(this.dataType) || DateType.DATE.equals(this.dataType));
        return (Integer)this.getValidatedValue(n, Integer.class);
    }

    @Override
    public long getLong(int n) {
        Preconditions.checkArgument(LongType.LONG.equals(this.dataType) || TimestampType.TIMESTAMP.equals(this.dataType) || TimestampNTZType.TIMESTAMP_NTZ.equals(this.dataType));
        return (Long)this.getValidatedValue(n, Long.class);
    }

    @Override
    public float getFloat(int n) {
        Preconditions.checkArgument(FloatType.FLOAT.equals(this.dataType));
        return ((Float)this.getValidatedValue(n, Float.class)).floatValue();
    }

    @Override
    public double getDouble(int n) {
        Preconditions.checkArgument(DoubleType.DOUBLE.equals(this.dataType));
        return (Double)this.getValidatedValue(n, Double.class);
    }

    @Override
    public BigDecimal getDecimal(int n) {
        Preconditions.checkArgument(this.dataType instanceof DecimalType);
        return (BigDecimal)this.getValidatedValue(n, BigDecimal.class);
    }

    @Override
    public String getString(int n) {
        Preconditions.checkArgument(StringType.STRING.equals(this.dataType));
        return (String)this.getValidatedValue(n, String.class);
    }

    @Override
    public byte[] getBinary(int n) {
        Preconditions.checkArgument(BinaryType.BINARY.equals(this.dataType));
        return (byte[])this.getValidatedValue(n, byte[].class);
    }

    @Override
    public ArrayValue getArray(int n) {
        Preconditions.checkArgument(this.dataType instanceof ArrayType);
        return (ArrayValue)this.getValidatedValue(n, ArrayValue.class);
    }

    @Override
    public MapValue getMap(int n) {
        Preconditions.checkArgument(this.dataType instanceof MapType);
        return (MapValue)this.getValidatedValue(n, MapValue.class);
    }

    @Override
    public ColumnVector getChild(int n) {
        Preconditions.checkArgument(this.dataType instanceof StructType);
        Preconditions.checkArgument(n < ((StructType)this.dataType).length());
        DataType dataType = ((StructType)this.dataType).at(n).getDataType();
        List<?> list = this.extractChildValues(n, dataType);
        return new GenericColumnVector(list, dataType);
    }

    private void validateRowId(int n) {
        Preconditions.checkArgument(n >= 0 && n < this.values.size(), "Invalid rowId: %s", n);
    }

    private Object getValidatedValue(int n, Class<?> clazz) {
        this.validateRowId(n);
        Object obj = this.values.get(n);
        Preconditions.checkArgument(clazz.isInstance(obj), "Value must be of type %s", clazz.getSimpleName());
        return obj;
    }

    private List<?> extractChildValues(int n, DataType dataType) {
        return this.values.stream().map(object -> this.extractChildValue(object, n, dataType)).collect(Collectors.toList());
    }

    private Object extractChildValue(Object object, int n, DataType dataType) {
        Preconditions.checkArgument(object instanceof Row);
        Row row = (Row)object;
        if (row.isNullAt(n)) {
            return null;
        }
        return this.extractTypedValue(row, n, dataType);
    }

    private Object extractTypedValue(Row row, int n, DataType dataType) {
        if (dataType instanceof BooleanType) {
            return row.getBoolean(n);
        }
        if (dataType instanceof ByteType) {
            return row.getByte(n);
        }
        if (dataType instanceof ShortType) {
            return row.getShort(n);
        }
        if (dataType instanceof IntegerType || dataType instanceof DateType) {
            return row.getInt(n);
        }
        if (dataType instanceof LongType || dataType instanceof TimestampType || dataType instanceof TimestampNTZType) {
            return row.getLong(n);
        }
        if (dataType instanceof FloatType) {
            return Float.valueOf(row.getFloat(n));
        }
        if (dataType instanceof DoubleType) {
            return row.getDouble(n);
        }
        if (dataType instanceof StringType) {
            return row.getString(n);
        }
        if (dataType instanceof BinaryType) {
            return row.getBinary(n);
        }
        if (dataType instanceof DecimalType) {
            return row.getDecimal(n);
        }
        if (dataType instanceof StructType) {
            return row.getStruct(n);
        }
        if (dataType instanceof ArrayType) {
            return row.getArray(n);
        }
        if (dataType instanceof MapType) {
            return row.getMap(n);
        }
        throw new UnsupportedOperationException(String.format("Unsupported data type: %s", dataType.getClass().getSimpleName()));
    }
}

