/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.files;

import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.internal.files.ParsedLogData;
import io.delta.kernel.internal.files.ParsedMultiPartCheckpointData;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.utils.FileStatus;
import java.util.Optional;

public class ParsedCheckpointData
extends ParsedLogData {
    public static ParsedCheckpointData forFileStatus(FileStatus fileStatus) {
        ParsedLogData.ParsedLogType parsedLogType;
        long l;
        String string = fileStatus.getPath();
        if (FileNames.isMultiPartCheckpointFile(string)) {
            return ParsedMultiPartCheckpointData.forFileStatus(fileStatus);
        }
        if (FileNames.isClassicCheckpointFile(string)) {
            l = FileNames.checkpointVersion(string);
            parsedLogType = ParsedLogData.ParsedLogType.CLASSIC_CHECKPOINT;
        } else if (FileNames.isV2CheckpointFile(string)) {
            l = FileNames.checkpointVersion(string);
            parsedLogType = ParsedLogData.ParsedLogType.V2_CHECKPOINT;
        } else {
            throw new IllegalArgumentException("File is not a recognized checkpoint type: " + string);
        }
        return new ParsedCheckpointData(l, parsedLogType, Optional.of(fileStatus), Optional.empty());
    }

    public static ParsedCheckpointData forInlineData(long l, ParsedLogData.ParsedLogType parsedLogType, ColumnarBatch columnarBatch) {
        if (parsedLogType == ParsedLogData.ParsedLogType.MULTIPART_CHECKPOINT) {
            throw new IllegalArgumentException("For MULTIPART_CHECKPOINT, use ParsedMultiPartCheckpointData.forInlineData() instead");
        }
        return new ParsedCheckpointData(l, parsedLogType, Optional.empty(), Optional.of(columnarBatch));
    }

    protected ParsedCheckpointData(long l, ParsedLogData.ParsedLogType parsedLogType, Optional<FileStatus> optional, Optional<ColumnarBatch> optional2) {
        super(l, parsedLogType, optional, optional2);
        Preconditions.checkArgument(parsedLogType.category == ParsedLogData.ParsedLogCategory.CHECKPOINT, "Must be a checkpoint");
    }
}

