/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.files;

import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.internal.files.ParsedCheckpointData;
import io.delta.kernel.internal.files.ParsedLogCompactionData;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.utils.FileStatus;
import java.util.Objects;
import java.util.Optional;

public class ParsedLogData {
    public final long version;
    public final ParsedLogType type;
    public final Optional<FileStatus> fileStatusOpt;
    public final Optional<ColumnarBatch> inlineDataOpt;

    public static ParsedLogData forFileStatus(FileStatus fileStatus) {
        ParsedLogType parsedLogType;
        long l;
        String string = fileStatus.getPath();
        if (FileNames.isLogCompactionFile(string)) {
            return ParsedLogCompactionData.forFileStatus(fileStatus);
        }
        if (FileNames.isCheckpointFile(string)) {
            return ParsedCheckpointData.forFileStatus(fileStatus);
        }
        if (FileNames.isPublishedDeltaFile(string)) {
            l = FileNames.deltaVersion(string);
            parsedLogType = ParsedLogType.PUBLISHED_DELTA;
        } else if (FileNames.isStagedDeltaFile(string)) {
            l = FileNames.deltaVersion(string);
            parsedLogType = ParsedLogType.RATIFIED_STAGED_COMMIT;
        } else if (FileNames.isChecksumFile(string)) {
            l = FileNames.checksumVersion(string);
            parsedLogType = ParsedLogType.CHECKSUM;
        } else {
            throw new IllegalArgumentException("Unknown log file type: " + string);
        }
        return new ParsedLogData(l, parsedLogType, Optional.of(fileStatus), Optional.empty());
    }

    public static ParsedLogData forInlineData(long l, ParsedLogType parsedLogType, ColumnarBatch columnarBatch) {
        if (parsedLogType == ParsedLogType.PUBLISHED_DELTA || parsedLogType == ParsedLogType.RATIFIED_STAGED_COMMIT) {
            throw new IllegalArgumentException("For PUBLISHED_DELTA|RATIFIED_STAGED_COMMIT, use ParsedLogData.forFileStatus() instead");
        }
        if (parsedLogType == ParsedLogType.LOG_COMPACTION) {
            throw new IllegalArgumentException("For LOG_COMPACTION, use ParsedLogCompactionData.forInlineData() instead");
        }
        if (parsedLogType.category == ParsedLogCategory.CHECKPOINT) {
            return ParsedCheckpointData.forInlineData(l, parsedLogType, columnarBatch);
        }
        return new ParsedLogData(l, parsedLogType, Optional.empty(), Optional.of(columnarBatch));
    }

    protected ParsedLogData(long l, ParsedLogType parsedLogType, Optional<FileStatus> optional, Optional<ColumnarBatch> optional2) {
        Preconditions.checkArgument(optional.isPresent() ^ optional2.isPresent(), "Exactly one of fileStatusOpt or inlineDataOpt must be present");
        Preconditions.checkArgument(l >= 0L, "version must be non-negative");
        this.version = l;
        this.type = parsedLogType;
        this.fileStatusOpt = optional;
        this.inlineDataOpt = optional2;
    }

    public boolean isMaterialized() {
        return this.fileStatusOpt.isPresent();
    }

    public boolean isInline() {
        return this.inlineDataOpt.isPresent();
    }

    public FileStatus getFileStatus() {
        return this.fileStatusOpt.get();
    }

    public ColumnarBatch getInlineData() {
        return this.inlineDataOpt.get();
    }

    public ParsedLogCategory getCategory() {
        return this.type.category;
    }

    protected void appendAdditionalToStringFields(StringBuilder stringBuilder) {
    }

    public boolean equals(Object object) {
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        ParsedLogData parsedLogData = (ParsedLogData)object;
        return this.version == parsedLogData.version && this.type == parsedLogData.type && Objects.equals(this.fileStatusOpt, parsedLogData.fileStatusOpt) && Objects.equals(this.inlineDataOpt, parsedLogData.inlineDataOpt);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.version, this.type, this.fileStatusOpt, this.inlineDataOpt});
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(this.getClass().getSimpleName()).append("{version=").append(this.version).append(", type=").append((Object)this.type).append(", source=");
        if (this.isMaterialized()) {
            stringBuilder.append(this.fileStatusOpt.get());
        } else {
            stringBuilder.append("inline");
        }
        this.appendAdditionalToStringFields(stringBuilder);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    public static enum ParsedLogType {
        PUBLISHED_DELTA(ParsedLogCategory.DELTA),
        RATIFIED_STAGED_COMMIT(ParsedLogCategory.DELTA),
        RATIFIED_INLINE_COMMIT(ParsedLogCategory.DELTA),
        LOG_COMPACTION(ParsedLogCategory.LOG_COMPACTION),
        CLASSIC_CHECKPOINT(ParsedLogCategory.CHECKPOINT),
        MULTIPART_CHECKPOINT(ParsedLogCategory.CHECKPOINT),
        V2_CHECKPOINT(ParsedLogCategory.CHECKPOINT),
        CHECKSUM(ParsedLogCategory.CHECKSUM);

        public final ParsedLogCategory category;

        private ParsedLogType(ParsedLogCategory parsedLogCategory) {
            this.category = parsedLogCategory;
        }
    }

    public static enum ParsedLogCategory {
        DELTA,
        LOG_COMPACTION,
        CHECKPOINT,
        CHECKSUM;

    }
}

