/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.hook;

import io.delta.kernel.Table;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.hook.PostCommitHook;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.Preconditions;
import java.io.IOException;
import java.util.Objects;

public class ChecksumFullHook
implements PostCommitHook {
    private final Path tablePath;
    private final long version;

    public ChecksumFullHook(Path path, long l) {
        this.tablePath = Objects.requireNonNull(path);
        this.version = l;
    }

    @Override
    public void threadSafeInvoke(Engine engine) throws IOException {
        Preconditions.checkArgument(engine != null);
        Table.forPath(engine, this.tablePath.toString()).checksum(engine, this.version);
    }

    @Override
    public PostCommitHook.PostCommitHookType getType() {
        return PostCommitHook.PostCommitHookType.CHECKSUM_FULL;
    }
}

