/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.hook;

import io.delta.kernel.engine.Engine;
import io.delta.kernel.hook.PostCommitHook;
import io.delta.kernel.internal.checksum.CRCInfo;
import io.delta.kernel.internal.checksum.ChecksumWriter;
import io.delta.kernel.internal.fs.Path;
import io.delta.kernel.internal.util.Preconditions;
import java.io.IOException;
import java.util.Objects;

public class ChecksumSimpleHook
implements PostCommitHook {
    private final CRCInfo crcInfo;
    private final Path logPath;

    public ChecksumSimpleHook(CRCInfo cRCInfo, Path path) {
        this.crcInfo = Objects.requireNonNull(cRCInfo);
        this.logPath = Objects.requireNonNull(path);
    }

    @Override
    public void threadSafeInvoke(Engine engine) throws IOException {
        Preconditions.checkArgument(engine != null);
        new ChecksumWriter(this.logPath).writeCheckSum(engine, this.crcInfo);
    }

    @Override
    public PostCommitHook.PostCommitHookType getType() {
        return PostCommitHook.PostCommitHookType.CHECKSUM_SIMPLE;
    }
}

