/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.hook;

import io.delta.kernel.engine.Engine;
import io.delta.kernel.hook.PostCommitHook;
import io.delta.kernel.internal.annotation.VisibleForTesting;
import io.delta.kernel.internal.compaction.LogCompactionWriter;
import io.delta.kernel.internal.fs.Path;
import java.io.IOException;
import java.util.Objects;

public class LogCompactionHook
implements PostCommitHook {
    private final Path dataPath;
    private final Path logPath;
    private final long startVersion;
    private final long commitVersion;
    private final long minFileRetentionTimestampMillis;

    public LogCompactionHook(Path path, Path path2, long l, long l2, long l3) {
        this.dataPath = Objects.requireNonNull(path, "dataPath cannot be null");
        this.logPath = Objects.requireNonNull(path2, "logPath cannot be null");
        this.startVersion = l;
        this.commitVersion = l2;
        this.minFileRetentionTimestampMillis = l3;
    }

    @Override
    public void threadSafeInvoke(Engine engine) throws IOException {
        LogCompactionWriter logCompactionWriter = new LogCompactionWriter(this.dataPath, this.logPath, this.startVersion, this.commitVersion, this.minFileRetentionTimestampMillis);
        logCompactionWriter.writeLogCompactionFile(engine);
    }

    @Override
    public PostCommitHook.PostCommitHookType getType() {
        return PostCommitHook.PostCommitHookType.LOG_COMPACTION;
    }

    @VisibleForTesting
    public Path getDataPath() {
        return this.dataPath;
    }

    @VisibleForTesting
    public Path getLogPath() {
        return this.logPath;
    }

    @VisibleForTesting
    public long getStartVersion() {
        return this.startVersion;
    }

    @VisibleForTesting
    public long getCommitVersion() {
        return this.commitVersion;
    }

    @VisibleForTesting
    public long getMinFileRetentionTimestampMillis() {
        return this.minFileRetentionTimestampMillis;
    }
}

