/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.icebergcompat;

import io.delta.kernel.exceptions.KernelException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.tablefeatures.TableFeature;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;

public abstract class IcebergCompatMetadataValidatorAndUpdater {
    Optional<Metadata> validateAndUpdateMetadata(IcebergCompatInputContext icebergCompatInputContext) {
        Optional<Metadata> optional;
        if (!this.requiredDeltaTableProperty().fromMetadata(icebergCompatInputContext.newMetadata).booleanValue()) {
            return Optional.empty();
        }
        boolean bl = false;
        List<IcebergCompatRequiredTablePropertyEnforcer> list = this.requiredDeltaTableProperties();
        for (IcebergCompatRequiredTablePropertyEnforcer object : list) {
            optional = object.validateAndUpdate(icebergCompatInputContext, this.compatFeatureName());
            if (!optional.isPresent()) continue;
            icebergCompatInputContext = icebergCompatInputContext.withUpdatedMetadata(optional.get());
            bl = true;
        }
        for (IcebergCompatRequiredTablePropertyEnforcer icebergCompatRequiredTablePropertyEnforcer : list) {
            optional = icebergCompatRequiredTablePropertyEnforcer.postMetadataProcessor.postProcess(icebergCompatInputContext);
            if (!optional.isPresent()) continue;
            bl = true;
            icebergCompatInputContext = icebergCompatInputContext.withUpdatedMetadata(optional.get());
        }
        for (TableFeature tableFeature : this.requiredDependencyTableFeatures()) {
            if (icebergCompatInputContext.newProtocol.supportsFeature(tableFeature)) continue;
            throw DeltaErrors.icebergCompatRequiredFeatureMissing(this.compatFeatureName(), tableFeature.featureName());
        }
        for (IcebergCompatCheck icebergCompatCheck : this.icebergCompatChecks()) {
            icebergCompatCheck.check(icebergCompatInputContext);
        }
        return bl ? Optional.of(icebergCompatInputContext.newMetadata) : Optional.empty();
    }

    abstract String compatFeatureName();

    abstract TableConfig<Boolean> requiredDeltaTableProperty();

    abstract List<IcebergCompatRequiredTablePropertyEnforcer> requiredDeltaTableProperties();

    abstract List<TableFeature> requiredDependencyTableFeatures();

    abstract List<IcebergCompatCheck> icebergCompatChecks();

    public static class IcebergCompatInputContext {
        final boolean isCreatingNewTable;
        final Metadata newMetadata;
        final Protocol newProtocol;

        public IcebergCompatInputContext(boolean bl, Metadata metadata, Protocol protocol) {
            this.isCreatingNewTable = bl;
            this.newMetadata = metadata;
            this.newProtocol = protocol;
        }

        public IcebergCompatInputContext withUpdatedMetadata(Metadata metadata) {
            return new IcebergCompatInputContext(this.isCreatingNewTable, metadata, this.newProtocol);
        }
    }

    static class IcebergCompatRequiredTablePropertyEnforcer<T> {
        public final TableConfig<T> property;
        public final Predicate<T> validator;
        public final String autoSetValue;
        public final PostMetadataProcessor postMetadataProcessor;

        IcebergCompatRequiredTablePropertyEnforcer(TableConfig<T> tableConfig, Predicate<T> predicate, String string, PostMetadataProcessor postMetadataProcessor) {
            this.property = tableConfig;
            this.validator = predicate;
            this.autoSetValue = string;
            this.postMetadataProcessor = postMetadataProcessor;
        }

        IcebergCompatRequiredTablePropertyEnforcer(TableConfig<T> tableConfig, Predicate<T> predicate, String string) {
            this(tableConfig, predicate, string, icebergCompatInputContext -> Optional.empty());
        }

        Optional<Metadata> validateAndUpdate(IcebergCompatInputContext icebergCompatInputContext, String string) {
            Metadata metadata = icebergCompatInputContext.newMetadata;
            T t = this.property.fromMetadata(metadata);
            boolean bl = this.validator.test(t);
            boolean bl2 = metadata.getConfiguration().containsKey(this.property.getKey());
            if (!bl) {
                if (!bl2 && icebergCompatInputContext.isCreatingNewTable) {
                    metadata = metadata.withMergedConfiguration(Collections.singletonMap(this.property.getKey(), this.autoSetValue));
                    return Optional.of(metadata);
                }
                throw new KernelException(String.format("The value '%s' for the property '%s' is not compatible with %s requirements", t, this.property.getKey(), string));
            }
            return Optional.empty();
        }
    }

    static interface PostMetadataProcessor {
        public Optional<Metadata> postProcess(IcebergCompatInputContext var1);
    }

    static interface IcebergCompatCheck {
        public void check(IcebergCompatInputContext var1);
    }
}

