/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.icebergcompat;

import io.delta.kernel.exceptions.InvalidConfigurationValueException;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.Metadata;
import java.util.Set;

public class IcebergUniversalFormatMetadataValidatorAndUpdater {
    private IcebergUniversalFormatMetadataValidatorAndUpdater() {
    }

    public static void validate(Metadata metadata) {
        if (!metadata.getConfiguration().containsKey(TableConfig.UNIVERSAL_FORMAT_ENABLED_FORMATS.getKey())) {
            return;
        }
        Set<String> set = TableConfig.UNIVERSAL_FORMAT_ENABLED_FORMATS.fromMetadata(metadata);
        boolean bl = set.contains("iceberg");
        boolean bl2 = TableConfig.ICEBERG_COMPAT_V2_ENABLED.fromMetadata(metadata);
        if (bl && !bl2) {
            throw new InvalidConfigurationValueException(TableConfig.UNIVERSAL_FORMAT_ENABLED_FORMATS.getKey(), "iceberg", String.format("'%s' must be set to \"true\" to enable iceberg uniform format.", TableConfig.ICEBERG_COMPAT_V2_ENABLED.getKey()));
        }
    }
}

