/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.metrics;

import io.delta.kernel.internal.metrics.SnapshotMetrics;
import java.util.Optional;

public class SnapshotQueryContext {
    private final String tablePath;
    private Optional<Long> version;
    private final Optional<Long> providedTimestamp;
    private final SnapshotMetrics snapshotMetrics = new SnapshotMetrics();

    public static SnapshotQueryContext forLatestSnapshot(String string) {
        return new SnapshotQueryContext(string, Optional.empty(), Optional.empty());
    }

    public static SnapshotQueryContext forVersionSnapshot(String string, long l) {
        return new SnapshotQueryContext(string, Optional.of(l), Optional.empty());
    }

    public static SnapshotQueryContext forTimestampSnapshot(String string, long l) {
        return new SnapshotQueryContext(string, Optional.empty(), Optional.of(l));
    }

    private SnapshotQueryContext(String string, Optional<Long> optional, Optional<Long> optional2) {
        this.tablePath = string;
        this.version = optional;
        this.providedTimestamp = optional2;
    }

    public String getTablePath() {
        return this.tablePath;
    }

    public Optional<Long> getVersion() {
        return this.version;
    }

    public Optional<Long> getProvidedTimestamp() {
        return this.providedTimestamp;
    }

    public SnapshotMetrics getSnapshotMetrics() {
        return this.snapshotMetrics;
    }

    public void setVersion(long l) {
        this.version = Optional.of(l);
    }

    public String toString() {
        return String.format("SnapshotQueryContext(tablePath=%s, version=%s, providedTimestamp=%s, snapshotMetric=%s)", this.tablePath, this.version, this.providedTimestamp, this.snapshotMetrics);
    }
}

