/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.metrics;

import io.delta.kernel.internal.metrics.DeltaOperationReportImpl;
import io.delta.kernel.internal.metrics.SnapshotMetrics;
import io.delta.kernel.internal.metrics.SnapshotQueryContext;
import io.delta.kernel.metrics.SnapshotMetricsResult;
import io.delta.kernel.metrics.SnapshotReport;
import java.util.Objects;
import java.util.Optional;

public class SnapshotReportImpl
extends DeltaOperationReportImpl
implements SnapshotReport {
    private final SnapshotMetricsResult snapshotMetrics;
    private final Optional<Long> version;
    private final Optional<Long> providedTimestamp;

    public static SnapshotReport forError(SnapshotQueryContext snapshotQueryContext, Exception exception) {
        return new SnapshotReportImpl(snapshotQueryContext.getTablePath(), snapshotQueryContext.getSnapshotMetrics(), snapshotQueryContext.getVersion(), snapshotQueryContext.getProvidedTimestamp(), Optional.of(exception));
    }

    public static SnapshotReport forSuccess(SnapshotQueryContext snapshotQueryContext) {
        return new SnapshotReportImpl(snapshotQueryContext.getTablePath(), snapshotQueryContext.getSnapshotMetrics(), snapshotQueryContext.getVersion(), snapshotQueryContext.getProvidedTimestamp(), Optional.empty());
    }

    private SnapshotReportImpl(String string, SnapshotMetrics snapshotMetrics, Optional<Long> optional, Optional<Long> optional2, Optional<Exception> optional3) {
        super(string, optional3);
        this.snapshotMetrics = Objects.requireNonNull(snapshotMetrics).captureSnapshotMetricsResult();
        this.version = Objects.requireNonNull(optional);
        this.providedTimestamp = Objects.requireNonNull(optional2);
    }

    @Override
    public SnapshotMetricsResult getSnapshotMetrics() {
        return this.snapshotMetrics;
    }

    @Override
    public Optional<Long> getVersion() {
        return this.version;
    }

    @Override
    public Optional<Long> getProvidedTimestamp() {
        return this.providedTimestamp;
    }
}

