/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.replay;

import io.delta.kernel.data.ColumnVector;
import io.delta.kernel.data.ColumnarBatch;
import io.delta.kernel.data.Row;
import io.delta.kernel.engine.Engine;
import io.delta.kernel.exceptions.ConcurrentWriteException;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.TransactionImpl;
import io.delta.kernel.internal.actions.CommitInfo;
import io.delta.kernel.internal.actions.DomainMetadata;
import io.delta.kernel.internal.actions.SetTransaction;
import io.delta.kernel.internal.actions.SingleAction;
import io.delta.kernel.internal.checksum.CRCInfo;
import io.delta.kernel.internal.checksum.ChecksumReader;
import io.delta.kernel.internal.replay.ActionsIterator;
import io.delta.kernel.internal.rowtracking.RowTracking;
import io.delta.kernel.internal.rowtracking.RowTrackingMetadataDomain;
import io.delta.kernel.internal.tablefeatures.TableFeatures;
import io.delta.kernel.internal.util.DomainMetadataUtils;
import io.delta.kernel.internal.util.FileNames;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.utils.CloseableIterable;
import io.delta.kernel.utils.CloseableIterator;
import io.delta.kernel.utils.FileStatus;
import java.io.Closeable;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicReference;

public class ConflictChecker {
    private static final int PROTOCOL_ORDINAL = SingleAction.CONFLICT_RESOLUTION_SCHEMA.indexOf("protocol");
    private static final int METADATA_ORDINAL = SingleAction.CONFLICT_RESOLUTION_SCHEMA.indexOf("metaData");
    private static final int TXN_ORDINAL = SingleAction.CONFLICT_RESOLUTION_SCHEMA.indexOf("txn");
    private static final int COMMITINFO_ORDINAL = SingleAction.CONFLICT_RESOLUTION_SCHEMA.indexOf("commitInfo");
    private static final int DOMAIN_METADATA_ORDINAL = SingleAction.CONFLICT_RESOLUTION_SCHEMA.indexOf("domainMetadata");
    private final SnapshotImpl snapshot;
    private final TransactionImpl transaction;
    private final long attemptVersion;
    private final CloseableIterable<Row> attemptDataActions;
    private final List<DomainMetadata> attemptDomainMetadatas;
    private Optional<Long> lastWinningRowIdHighWatermark = Optional.empty();

    private ConflictChecker(SnapshotImpl snapshotImpl, TransactionImpl transactionImpl, long l, List<DomainMetadata> list, CloseableIterable<Row> closeableIterable) {
        this.snapshot = snapshotImpl;
        this.transaction = transactionImpl;
        this.attemptVersion = l;
        this.attemptDomainMetadatas = list;
        this.attemptDataActions = closeableIterable;
    }

    public static TransactionRebaseState resolveConflicts(Engine engine, SnapshotImpl snapshotImpl, long l, TransactionImpl transactionImpl, List<DomainMetadata> list, CloseableIterable<Row> closeableIterable) throws ConcurrentWriteException {
        return new ConflictChecker(snapshotImpl, transactionImpl, l, list, closeableIterable).resolveConflicts(engine);
    }

    public TransactionRebaseState resolveConflicts(Engine engine) throws ConcurrentWriteException {
        Closeable closeable;
        List<FileStatus> list = this.getWinningCommitFiles(engine);
        AtomicReference atomicReference = new AtomicReference(Optional.empty());
        Preconditions.checkState(!list.isEmpty(), "No winning commits found.");
        FileStatus fileStatus = list.get(list.size() - 1);
        long l = FileNames.deltaVersion(fileStatus.getPath());
        try {
            closeable = new ActionsIterator(engine, list, SingleAction.CONFLICT_RESOLUTION_SCHEMA, Optional.empty());
            try {
                closeable.forEachRemaining(actionWrapper -> {
                    Preconditions.checkArgument(!actionWrapper.isFromCheckpoint());
                    ColumnarBatch columnarBatch = actionWrapper.getColumnarBatch();
                    if (actionWrapper.getVersion() == l) {
                        Optional<CommitInfo> optional = this.getCommitInfo(columnarBatch.getColumnVector(COMMITINFO_ORDINAL));
                        atomicReference.set(optional);
                    }
                    this.handleProtocol(columnarBatch.getColumnVector(PROTOCOL_ORDINAL));
                    this.handleMetadata(columnarBatch.getColumnVector(METADATA_ORDINAL));
                    this.handleTxn(columnarBatch.getColumnVector(TXN_ORDINAL));
                    this.handleDomainMetadata(columnarBatch.getColumnVector(DOMAIN_METADATA_ORDINAL));
                });
            }
            finally {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            throw new UncheckedIOException("Error reading actions from winning commits.", iOException);
        }
        closeable = this.attemptDataActions;
        List<DomainMetadata> list2 = this.attemptDomainMetadatas;
        if (TableFeatures.isRowTrackingSupported(this.transaction.getProtocol())) {
            list2 = RowTracking.updateRowIdHighWatermarkIfNeeded(this.snapshot, this.transaction.getProtocol(), this.lastWinningRowIdHighWatermark, this.attemptDataActions, this.attemptDomainMetadatas);
            closeable = RowTracking.assignBaseRowIdAndDefaultRowCommitVersion(this.snapshot, this.transaction.getProtocol(), this.lastWinningRowIdHighWatermark, Optional.of(this.attemptVersion), l + 1L, this.attemptDataActions);
        }
        Optional<CRCInfo> optional = ChecksumReader.getCRCInfo(engine, FileStatus.of(FileNames.checksumFile(this.snapshot.getLogPath(), l).toString()));
        return new TransactionRebaseState(l, this.getLastCommitTimestamp(l, fileStatus, atomicReference.get()), (CloseableIterable<Row>)closeable, list2, optional);
    }

    private void handleProtocol(ColumnVector columnVector) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i)) continue;
            throw DeltaErrors.protocolChangedException(this.attemptVersion);
        }
    }

    private void handleMetadata(ColumnVector columnVector) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i)) continue;
            throw DeltaErrors.metadataChangedException();
        }
    }

    private Map<String, DomainMetadata> handleDomainMetadata(ColumnVector columnVector) {
        HashMap<String, DomainMetadata> hashMap = new HashMap<String, DomainMetadata>();
        DomainMetadataUtils.populateDomainMetadataMap(columnVector, hashMap);
        block6: for (DomainMetadata domainMetadata : this.attemptDomainMetadatas) {
            String string = domainMetadata.getDomain();
            DomainMetadata domainMetadata2 = (DomainMetadata)hashMap.get(string);
            if (domainMetadata2 == null) continue;
            switch (string) {
                case "delta.rowTracking": {
                    long l = RowTrackingMetadataDomain.fromJsonConfiguration(domainMetadata2.getConfiguration()).getRowIdHighWaterMark();
                    Preconditions.checkState(!this.lastWinningRowIdHighWatermark.isPresent() || this.lastWinningRowIdHighWatermark.get() <= l, "row ID high watermark should be monotonically increasing");
                    this.lastWinningRowIdHighWatermark = Optional.of(l);
                    continue block6;
                }
            }
            throw DeltaErrors.concurrentDomainMetadataAction(domainMetadata, domainMetadata2);
        }
        return hashMap;
    }

    private Optional<CommitInfo> getCommitInfo(ColumnVector columnVector) {
        for (int i = 0; i < columnVector.getSize(); ++i) {
            if (columnVector.isNullAt(i)) continue;
            return Optional.of(CommitInfo.fromColumnVector(columnVector, i));
        }
        return Optional.empty();
    }

    private void handleTxn(ColumnVector columnVector) {
        Optional<SetTransaction> optional = this.transaction.getSetTxnOpt();
        optional.ifPresent(setTransaction -> {
            for (int i = 0; i < columnVector.getSize(); ++i) {
                SetTransaction setTransaction2 = SetTransaction.fromColumnVector(columnVector, i);
                if (setTransaction2 == null || !setTransaction2.getAppId().equals(setTransaction.getAppId()) || setTransaction2.getVersion() < setTransaction.getVersion()) continue;
                throw DeltaErrors.concurrentTransaction(setTransaction.getAppId(), setTransaction.getVersion(), setTransaction2.getVersion());
            }
        });
    }

    private List<FileStatus> getWinningCommitFiles(Engine engine) {
        Object object;
        block10: {
            String string = FileNames.deltaFile(this.snapshot.getLogPath(), this.snapshot.getVersion() + 1L);
            CloseableIterator closeableIterator = DeltaErrors.wrapEngineExceptionThrowsIO(() -> engine.getFileSystemClient().listFrom(string), "Listing from %s", string);
            try {
                ArrayList<FileStatus> arrayList = new ArrayList<FileStatus>();
                while (closeableIterator.hasNext()) {
                    object = (FileStatus)closeableIterator.next();
                    if (!FileNames.isCommitFile(((FileStatus)object).getPath())) continue;
                    arrayList.add((FileStatus)object);
                }
                object = ConflictChecker.ensureNoGapsInWinningCommits(arrayList);
                if (closeableIterator == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (closeableIterator != null) {
                        try {
                            closeableIterator.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (FileNotFoundException fileNotFoundException) {
                    throw new IllegalStateException("No winning commits found.", fileNotFoundException);
                }
                catch (IOException iOException) {
                    throw new UncheckedIOException("Error listing files from " + string, iOException);
                }
            }
            closeableIterator.close();
        }
        return object;
    }

    private long getLastCommitTimestamp(long l, FileStatus fileStatus, Optional<CommitInfo> optional) {
        if (this.snapshot.getVersion() == -1L || !TableConfig.IN_COMMIT_TIMESTAMPS_ENABLED.fromMetadata(this.snapshot.getMetadata()).booleanValue()) {
            return fileStatus.getModificationTime();
        }
        return CommitInfo.getRequiredInCommitTimestamp(optional, String.valueOf(l), this.snapshot.getDataPath());
    }

    private static List<FileStatus> ensureNoGapsInWinningCommits(List<FileStatus> list) {
        long l = -1L;
        for (FileStatus fileStatus : list) {
            long l2 = FileNames.deltaVersion(fileStatus.getPath());
            Preconditions.checkState(l == -1L || l2 == l + 1L, String.format("Gaps in Delta log commit files. Expected version %d but got %d", l + 1L, l2));
            l = l2;
        }
        return list;
    }

    public static class TransactionRebaseState {
        private final long latestVersion;
        private final long latestCommitTimestamp;
        private final CloseableIterable<Row> updatedDataActions;
        private final List<DomainMetadata> updatedDomainMetadatas;
        private final Optional<CRCInfo> updatedCrcInfo;

        public TransactionRebaseState(long l, long l2, CloseableIterable<Row> closeableIterable, List<DomainMetadata> list, Optional<CRCInfo> optional) {
            this.latestVersion = l;
            this.latestCommitTimestamp = l2;
            this.updatedDataActions = closeableIterable;
            this.updatedDomainMetadatas = list;
            this.updatedCrcInfo = optional;
        }

        public long getLatestVersion() {
            return this.latestVersion;
        }

        public long getLatestCommitTimestamp() {
            return this.latestCommitTimestamp;
        }

        public CloseableIterable<Row> getUpdatedDataActions() {
            return this.updatedDataActions;
        }

        public List<DomainMetadata> getUpdatedDomainMetadatas() {
            return this.updatedDomainMetadatas;
        }

        public Optional<CRCInfo> getUpdatedCrcInfo() {
            return this.updatedCrcInfo;
        }
    }
}

