/*
 * Decompiled with CFR 0.152.
 */
package io.delta.kernel.internal.rowtracking;

import io.delta.kernel.data.Row;
import io.delta.kernel.internal.DeltaErrors;
import io.delta.kernel.internal.SnapshotImpl;
import io.delta.kernel.internal.TableConfig;
import io.delta.kernel.internal.actions.AddFile;
import io.delta.kernel.internal.actions.DomainMetadata;
import io.delta.kernel.internal.actions.Metadata;
import io.delta.kernel.internal.actions.Protocol;
import io.delta.kernel.internal.actions.SingleAction;
import io.delta.kernel.internal.rowtracking.RowTrackingMetadataDomain;
import io.delta.kernel.internal.tablefeatures.TableFeatures;
import io.delta.kernel.internal.util.Preconditions;
import io.delta.kernel.utils.CloseableIterable;
import io.delta.kernel.utils.CloseableIterator;
import java.io.IOException;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;

public class RowTracking {
    private RowTracking() {
    }

    public static CloseableIterable<Row> assignBaseRowIdAndDefaultRowCommitVersion(final SnapshotImpl snapshotImpl, Protocol protocol, final Optional<Long> optional, final Optional<Long> optional2, final long l, final CloseableIterable<Row> closeableIterable) {
        Preconditions.checkArgument(TableFeatures.isRowTrackingSupported(protocol), "Base row ID and default row commit version are assigned only when feature 'rowTracking' is supported.");
        return new CloseableIterable<Row>(){

            @Override
            public void close() throws IOException {
                closeableIterable.close();
            }

            @Override
            public CloseableIterator<Row> iterator() {
                long l2 = RowTracking.readRowIdHighWaterMark(snapshotImpl);
                AtomicLong atomicLong = new AtomicLong(optional.orElse(l2));
                Preconditions.checkArgument(atomicLong.get() >= l2, "The current row ID high watermark must be greater than or equal to the high watermark from the transaction's read snapshot");
                return closeableIterable.iterator().map(row -> {
                    if (row.isNullAt(SingleAction.ADD_FILE_ORDINAL)) {
                        return row;
                    }
                    AddFile addFile = new AddFile(row.getStruct(SingleAction.ADD_FILE_ORDINAL));
                    if (!addFile.getBaseRowId().isPresent() || addFile.getBaseRowId().get() > l2) {
                        addFile = addFile.withNewBaseRowId(atomicLong.get() + 1L);
                        atomicLong.addAndGet(RowTracking.getNumRecordsOrThrow(addFile));
                    }
                    if (!addFile.getDefaultRowCommitVersion().isPresent() || addFile.getDefaultRowCommitVersion().get() == optional2.orElse(-1L)) {
                        addFile = addFile.withNewDefaultRowCommitVersion(l);
                    }
                    return SingleAction.createAddFileSingleAction(addFile.toRow());
                });
            }
        };
    }

    public static List<DomainMetadata> updateRowIdHighWatermarkIfNeeded(SnapshotImpl snapshotImpl, Protocol protocol, Optional<Long> optional, CloseableIterable<Row> closeableIterable, List<DomainMetadata> list) {
        Preconditions.checkArgument(TableFeatures.isRowTrackingSupported(protocol), "Row ID high watermark is updated only when feature 'rowTracking' is supported.");
        List<DomainMetadata> list2 = list.stream().filter(domainMetadata -> !domainMetadata.getDomain().equals("delta.rowTracking")).collect(Collectors.toList());
        long l = RowTracking.readRowIdHighWaterMark(snapshotImpl);
        AtomicLong atomicLong = new AtomicLong(optional.orElse(l));
        Preconditions.checkArgument(atomicLong.get() >= l, "The current row ID high watermark must be greater than or equal to the high watermark from the transaction's read snapshot");
        closeableIterable.forEach(row -> {
            AddFile addFile;
            if (!(row.isNullAt(SingleAction.ADD_FILE_ORDINAL) || (addFile = new AddFile(row.getStruct(SingleAction.ADD_FILE_ORDINAL))).getBaseRowId().isPresent() && addFile.getBaseRowId().get() <= l)) {
                atomicLong.addAndGet(RowTracking.getNumRecordsOrThrow(addFile));
            }
        });
        if (atomicLong.get() != l) {
            list2.add(new RowTrackingMetadataDomain(atomicLong.get()).toDomainMetadata());
        }
        return list2;
    }

    public static void throwIfRowTrackingToggled(Metadata metadata, Metadata metadata2) {
        boolean bl;
        boolean bl2 = TableConfig.ROW_TRACKING_ENABLED.fromMetadata(metadata);
        if (bl2 != (bl = TableConfig.ROW_TRACKING_ENABLED.fromMetadata(metadata2).booleanValue())) {
            throw DeltaErrors.cannotToggleRowTrackingOnExistingTable();
        }
    }

    private static long readRowIdHighWaterMark(SnapshotImpl snapshotImpl) {
        return RowTrackingMetadataDomain.fromSnapshot(snapshotImpl).map(RowTrackingMetadataDomain::getRowIdHighWaterMark).orElse(-1L);
    }

    private static long getNumRecordsOrThrow(AddFile addFile) {
        return addFile.getNumRecords().orElseThrow(DeltaErrors::missingNumRecordsStatsForRowTracking);
    }
}

